/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.citizensnpcs.api.ai.AttackStrategy;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.PathfinderType;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class NavigatorParameters
implements Cloneable {
    private int attackDelayTicks = 20;
    private double attackRange;
    private AttackStrategy attackStrategy;
    private boolean avoidWater;
    private float baseSpeed = 1.0f;
    private List<NavigatorCallback> callbacks = Lists.newArrayList();
    private boolean debug;
    private AttackStrategy defaultStrategy;
    private double destinationTeleportMargin = -1.0;
    private double distanceMargin = 2.0;
    private List<BlockExaminer> examiners = Lists.newArrayList();
    private int fallDistance = -1;
    private Function<Navigator, Location> lookAtFunction;
    private Function<Entity, Location> mapper;
    private double pathDistanceMargin = 1.0;
    private PathfinderType pathfinderType;
    private float range;
    private List<Runnable> runCallbacks = Lists.newArrayList();
    private float speedModifier = 1.0f;
    private int stationaryTicks = -1;
    private float straightLineTargetingDistance;
    private StuckAction stuckAction;
    private int updatePathRate;
    private static final Function<Entity, Location> DEFAULT_MAPPER = Entity::getLocation;
    private static final BlockExaminer[] EMPTY_EXAMINERS = new BlockExaminer[0];

    public NavigatorParameters addRunCallback(Runnable callback) {
        this.runCallbacks.add(callback);
        return this;
    }

    public NavigatorParameters addSingleUseCallback(NavigatorCallback callback) {
        this.callbacks.add(callback);
        return this;
    }

    public int attackDelayTicks() {
        return this.attackDelayTicks;
    }

    public NavigatorParameters attackDelayTicks(int ticks) {
        this.attackDelayTicks = ticks;
        return this;
    }

    public double attackRange() {
        return this.attackRange;
    }

    public NavigatorParameters attackRange(double range) {
        this.attackRange = range;
        return this;
    }

    public AttackStrategy attackStrategy() {
        return this.attackStrategy == null ? this.defaultStrategy : this.attackStrategy;
    }

    public void attackStrategy(AttackStrategy strategy) {
        this.attackStrategy = strategy;
    }

    public boolean avoidWater() {
        return this.avoidWater;
    }

    public NavigatorParameters avoidWater(boolean avoidWater) {
        this.avoidWater = avoidWater;
        return this;
    }

    public float baseSpeed() {
        return this.baseSpeed;
    }

    public NavigatorParameters baseSpeed(float speed) {
        this.baseSpeed = speed;
        return this;
    }

    public Iterable<NavigatorCallback> callbacks() {
        return this.callbacks;
    }

    public NavigatorParameters clearExaminers() {
        this.examiners.clear();
        return this;
    }

    public NavigatorParameters clone() {
        try {
            NavigatorParameters clone = (NavigatorParameters)super.clone();
            if (this.callbacks instanceof ArrayList) {
                clone.callbacks = (List)((ArrayList)this.callbacks).clone();
            }
            if (this.examiners instanceof ArrayList) {
                clone.examiners = (List)((ArrayList)this.examiners).clone();
            }
            if (this.runCallbacks instanceof ArrayList) {
                clone.runCallbacks = (List)((ArrayList)this.runCallbacks).clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean debug() {
        return this.debug;
    }

    public NavigatorParameters debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public AttackStrategy defaultAttackStrategy() {
        return this.defaultStrategy;
    }

    public NavigatorParameters defaultAttackStrategy(AttackStrategy defaultStrategy) {
        this.defaultStrategy = defaultStrategy;
        return this;
    }

    public double destinationTeleportMargin() {
        return this.destinationTeleportMargin;
    }

    public NavigatorParameters destinationTeleportMargin(double margin) {
        this.destinationTeleportMargin = margin;
        return this;
    }

    public double distanceMargin() {
        return this.distanceMargin;
    }

    public NavigatorParameters distanceMargin(double newMargin) {
        this.distanceMargin = newMargin;
        return this;
    }

    public Function<Entity, Location> entityTargetLocationMapper() {
        return this.mapper != null ? this.mapper : DEFAULT_MAPPER;
    }

    public NavigatorParameters entityTargetLocationMapper(Function<Entity, Location> mapper) {
        this.mapper = mapper;
        return this;
    }

    public NavigatorParameters examiner(BlockExaminer examiner) {
        this.examiners.add(examiner);
        return this;
    }

    public BlockExaminer[] examiners() {
        return this.examiners.size() == 0 ? EMPTY_EXAMINERS : this.examiners.toArray(new BlockExaminer[0]);
    }

    public int fallDistance() {
        return this.fallDistance;
    }

    public NavigatorParameters fallDistance(int distance) {
        this.fallDistance = distance;
        return this;
    }

    public boolean hasExaminer(Class<? extends BlockExaminer> clazz) {
        return this.examiners.stream().anyMatch(e -> clazz.isAssignableFrom(e.getClass()));
    }

    public Function<Navigator, Location> lookAtFunction() {
        return this.lookAtFunction;
    }

    public NavigatorParameters lookAtFunction(Function<Navigator, Location> lookAt) {
        this.lookAtFunction = lookAt;
        return this;
    }

    public float modifiedSpeed(float toModify) {
        return toModify * this.speedModifier();
    }

    public double pathDistanceMargin() {
        return this.pathDistanceMargin;
    }

    public NavigatorParameters pathDistanceMargin(double distance) {
        this.pathDistanceMargin = distance;
        return this;
    }

    public PathfinderType pathfinderType() {
        return this.pathfinderType;
    }

    public NavigatorParameters pathfinderType(PathfinderType type) {
        this.pathfinderType = type;
        return this;
    }

    public float range() {
        return this.range;
    }

    public NavigatorParameters range(float range) {
        this.range = range;
        return this;
    }

    public NavigatorParameters removeRunCallback(Runnable runnable) {
        this.runCallbacks.remove(runnable);
        return this;
    }

    public void run() {
        for (int i = 0; i < this.runCallbacks.size(); ++i) {
            this.runCallbacks.get(i).run();
        }
    }

    public float speed() {
        return this.modifiedSpeed(this.baseSpeed);
    }

    @Deprecated
    public NavigatorParameters speed(float speed) {
        this.baseSpeed = speed;
        return this;
    }

    public float speedModifier() {
        return this.speedModifier;
    }

    public NavigatorParameters speedModifier(float percent) {
        this.speedModifier = percent;
        return this;
    }

    public int stationaryTicks() {
        return this.stationaryTicks;
    }

    public NavigatorParameters stationaryTicks(int ticks) {
        this.stationaryTicks = ticks;
        return this;
    }

    public float straightLineTargetingDistance() {
        return this.straightLineTargetingDistance;
    }

    public NavigatorParameters straightLineTargetingDistance(float distance) {
        this.straightLineTargetingDistance = distance;
        return this;
    }

    public StuckAction stuckAction() {
        return this.stuckAction;
    }

    public NavigatorParameters stuckAction(StuckAction action) {
        this.stuckAction = action;
        return this;
    }

    public int updatePathRate() {
        return this.updatePathRate;
    }

    public NavigatorParameters updatePathRate(int rate) {
        this.updatePathRate = rate;
        return this;
    }

    @Deprecated
    public boolean useNewPathfinder() {
        return this.pathfinderType() == PathfinderType.CITIZENS;
    }

    @Deprecated
    public NavigatorParameters useNewPathfinder(boolean use) {
        if (use) {
            this.pathfinderType(PathfinderType.CITIZENS);
        } else {
            this.pathfinderType(PathfinderType.MINECRAFT);
        }
        return this;
    }

    public boolean withinMargin(Location a, Location b) {
        return this.withinMargin(a, b, this.distanceMargin());
    }

    public boolean withinMargin(Location a, Location b, double margin) {
        double dx = a.getX() - b.getX();
        double dy = a.getY() - b.getY();
        double dz = a.getZ() - b.getZ();
        return Math.abs(dy) < 1.0 && Math.sqrt(dx * dx + dz * dz) <= margin;
    }

    public boolean withinMargin(Vector a, Vector b) {
        double dx = a.getX() - b.getX();
        double dy = a.getY() - b.getY();
        double dz = a.getZ() - b.getZ();
        return Math.abs(dy) < 1.0 && Math.sqrt(dx * dx + dz * dz) <= this.distanceMargin();
    }
}

