/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorRegistry;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.ai.tree.CoalescedBehavior;
import net.citizensnpcs.api.ai.tree.IfElse;
import net.citizensnpcs.api.ai.tree.InstantBehavior;
import net.citizensnpcs.api.ai.tree.InverterDecorator;
import net.citizensnpcs.api.ai.tree.Loop;
import net.citizensnpcs.api.ai.tree.ParallelBehaviorWrapper;
import net.citizensnpcs.api.ai.tree.ParallelComposite;
import net.citizensnpcs.api.ai.tree.Selector;
import net.citizensnpcs.api.ai.tree.Sequence;
import net.citizensnpcs.api.ai.tree.TimeoutDecorator;
import net.citizensnpcs.api.expr.CompiledExpression;
import net.citizensnpcs.api.expr.ExpressionEngine;
import net.citizensnpcs.api.expr.ExpressionRegistry;
import net.citizensnpcs.api.expr.ExpressionScope;
import net.citizensnpcs.api.expr.Memory;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.Util;
import org.bukkit.entity.Player;

public class BehaviorTreeParser {
    private final BehaviorRegistry registry;
    private static final Behavior EMPTY = new Behavior(){

        @Override
        public void reset() {
        }

        @Override
        public BehaviorStatus run() {
            return BehaviorStatus.SUCCESS;
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }

        public String toString() {
            return "EmptyBehavior";
        }
    };

    public BehaviorTreeParser(BehaviorRegistry registry) {
        this.registry = registry;
    }

    private List<Behavior> coalesceInstantBehaviors(List<Behavior> behaviors) {
        ArrayList<Behavior> result = new ArrayList<Behavior>();
        ArrayList<Behavior> instantGroup = new ArrayList<Behavior>();
        for (Behavior behavior : behaviors) {
            if (behavior instanceof InstantBehavior) {
                instantGroup.add(behavior);
                continue;
            }
            if (!instantGroup.isEmpty()) {
                result.add(instantGroup.size() == 1 ? (Behavior)instantGroup.get(0) : new CoalescedBehavior(instantGroup));
                instantGroup = new ArrayList();
            }
            result.add(behavior);
        }
        if (!instantGroup.isEmpty()) {
            result.add(instantGroup.size() == 1 ? (Behavior)instantGroup.get(0) : new CoalescedBehavior(instantGroup));
        }
        return result;
    }

    private Behavior createCommandBehavior(final String command, final BehaviorRegistry.BehaviorContext context) {
        ExpressionRegistry expressions = this.registry.getExpressionRegistry();
        final ExpressionRegistry.ExpressionValue commandHolder = expressions.parseValue(command);
        return new InstantBehavior(){

            @Override
            public BehaviorStatus run() {
                String command2 = commandHolder.evaluateAsString(context.getScope());
                Util.runCommand(context.getNPC(), context.getNPC().getEntity() instanceof Player ? (Player)context.getNPC().getEntity() : null, command2, command2.contains("-o"), command2.contains("-p"));
                return BehaviorStatus.SUCCESS;
            }

            public String toString() {
                return "CommandBehavior[" + command + "]";
            }
        };
    }

    private Behavior createExpressionBehavior(final String expression, final BehaviorRegistry.BehaviorContext context) {
        ExpressionRegistry exprRegistry = this.registry.getExpressionRegistry();
        final ExpressionRegistry.ExpressionValue exprHolder = exprRegistry.parseValue(expression);
        return new InstantBehavior(){

            @Override
            public BehaviorStatus run() {
                exprHolder.evaluate(context.getScope());
                return BehaviorStatus.SUCCESS;
            }

            public String toString() {
                return "ExpressionBehavior[" + expression + "]";
            }
        };
    }

    public Behavior parse(DataKey root, NPC npc, ExpressionScope scope, Memory blackboard) {
        scope.setMemory(blackboard);
        scope.setNPC(npc);
        BehaviorRegistry.BehaviorContext context = new BehaviorRegistry.BehaviorContext(npc, scope, this.registry.getExpressionRegistry(), blackboard);
        return this.parseNode(root, context);
    }

    private Supplier<Boolean> parseCondition(String conditionStr, BehaviorRegistry.BehaviorContext context) {
        ExpressionRegistry exprRegistry = this.registry.getExpressionRegistry();
        if (exprRegistry.isPossiblyExpression(conditionStr)) {
            try {
                CompiledExpression expr = exprRegistry.compile(conditionStr);
                return () -> expr.evaluateAsBoolean(context.getScope());
            }
            catch (ExpressionEngine.ExpressionCompileException e) {
                e.printStackTrace();
                return () -> false;
            }
        }
        if (conditionStr.equalsIgnoreCase("true") || conditionStr.equals("1")) {
            return () -> true;
        }
        if (conditionStr.equalsIgnoreCase("false") || conditionStr.equals("0")) {
            return () -> false;
        }
        return () -> {
            Object value = context.getScope().get(conditionStr);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() != 0.0;
            }
            return value != null;
        };
    }

    private Behavior parseContainer(String name, DataKey key, BehaviorRegistry.BehaviorContext context) {
        if (name.startsWith("timeout ")) {
            String timeoutStr = name.substring(8).trim();
            ExpressionRegistry exprRegistry = this.registry.getExpressionRegistry();
            ExpressionRegistry.ExpressionValue timeoutHolder = exprRegistry.parseValue(timeoutStr);
            int ticks = (int)timeoutHolder.evaluateAsNumber(context.getScope());
            List<Behavior> children = this.parseContainerChildren(key, context);
            Behavior body = children.size() == 1 ? children.get(0) : Sequence.createSequence(this.coalesceInstantBehaviors(children));
            return new TimeoutDecorator(body, ticks);
        }
        if (name.equalsIgnoreCase("invert")) {
            List<Behavior> children = this.parseContainerChildren(key, context);
            Behavior body = children.size() == 1 ? children.get(0) : Sequence.createSequence(this.coalesceInstantBehaviors(children));
            return new InverterDecorator(body);
        }
        if (name.startsWith("loop ")) {
            String conditionStr = name.substring(5).trim();
            Supplier<Boolean> condition = this.parseCondition(conditionStr, context);
            List<Behavior> children = this.parseContainerChildren(key, context);
            Behavior body = children.size() == 1 ? children.get(0) : Sequence.createSequence(this.coalesceInstantBehaviors(children));
            return Loop.createWithCondition(body, condition);
        }
        if (name.equalsIgnoreCase("sequence") || name.equalsIgnoreCase("seq")) {
            List<Behavior> children = this.parseContainerChildren(key, context);
            return Sequence.createSequence(this.coalesceInstantBehaviors(children));
        }
        if (name.equalsIgnoreCase("random") || name.equalsIgnoreCase("selector")) {
            List<Behavior> children = this.parseContainerChildren(key, context);
            return Selector.selecting(children).build();
        }
        if (name.equalsIgnoreCase("parallel")) {
            ArrayList<Behavior> parallelWrapped = new ArrayList<Behavior>();
            for (Behavior child : this.parseContainerChildren(key, context)) {
                parallelWrapped.add(new ParallelBehaviorWrapper(child));
            }
            return new ParallelComposite(parallelWrapped);
        }
        if (name.equalsIgnoreCase("eval") || name.toLowerCase().startsWith("eval ")) {
            String language = null;
            if (name.length() > 5) {
                language = name.substring(5).trim();
            }
            return this.parseEvalBlock(key, language, context);
        }
        return this.parseLeaf(name, key, context);
    }

    private List<Behavior> parseContainerChildren(DataKey key, BehaviorRegistry.BehaviorContext context) {
        Behavior child;
        ArrayList<Behavior> children = new ArrayList<Behavior>();
        DataKey ifKey = null;
        DataKey elseKey = null;
        for (DataKey sub : key.getIntegerSubKeys()) {
            Behavior child2;
            if (sub.hasSubKeys()) {
                sub = sub.getSubKeys().iterator().next();
            }
            if (ifKey != null) {
                if (sub.name().equals("else")) {
                    elseKey = sub;
                }
                if ((child2 = this.parseIfElse(ifKey, elseKey, context)) != null) {
                    children.add(child2);
                }
                ifKey = null;
                elseKey = null;
                continue;
            }
            if (sub.name().startsWith("if ")) {
                ifKey = sub;
                continue;
            }
            child2 = this.parseNode(sub, context);
            if (child2 == null) continue;
            children.add(child2);
        }
        if (ifKey != null && (child = this.parseIfElse(ifKey, elseKey, context)) != null) {
            children.add(child);
        }
        return children;
    }

    private Behavior parseEvalBlock(DataKey key, String language, BehaviorRegistry.BehaviorContext context) {
        ExpressionRegistry exprRegistry = this.registry.getExpressionRegistry();
        ArrayList<CompiledExpression> expressions = new ArrayList<CompiledExpression>();
        String engineName = language != null ? language : exprRegistry.getDefaultEngineName();
        ExpressionEngine engine = exprRegistry.getEngine(engineName);
        if (engine == null) {
            Messaging.severe("Unknown expression language", engineName);
            return EMPTY;
        }
        for (DataKey sub : key.getIntegerSubKeys()) {
            String expr = sub.getString("");
            if (expr == null || expr.isEmpty()) continue;
            try {
                expressions.add(engine.compile(expr));
            }
            catch (ExpressionEngine.ExpressionCompileException e) {
                e.printStackTrace();
            }
        }
        return () -> {
            for (CompiledExpression expr : expressions) {
                expr.evaluate(context.getScope());
            }
            return BehaviorStatus.SUCCESS;
        };
    }

    private Behavior parseIfElse(DataKey ifKey, DataKey elseKey, BehaviorRegistry.BehaviorContext context) {
        Behavior ifBehavior;
        String conditionStr = ifKey.name().substring(3).trim();
        Supplier<Boolean> condition = this.parseCondition(conditionStr, context);
        if (ifKey.hasSubKeys()) {
            ArrayList<Behavior> children = new ArrayList<Behavior>();
            for (DataKey sub : ifKey.getIntegerSubKeys()) {
                Behavior child;
                if (sub.hasSubKeys()) {
                    sub = sub.getSubKeys().iterator().next();
                }
                if ((child = this.parseNode(sub, context)) == null) continue;
                children.add(child);
            }
            ifBehavior = children.size() == 1 ? (Behavior)children.get(0) : Sequence.createSequence(children);
        } else {
            String value = ifKey.getString("");
            ifBehavior = this.parseLeaf(value, null, context);
        }
        Behavior elseBehavior = null;
        if (elseKey != null) {
            if (elseKey.hasSubKeys()) {
                ArrayList<Behavior> children = new ArrayList<Behavior>();
                for (DataKey sub : elseKey.getIntegerSubKeys()) {
                    Behavior child;
                    if (sub.hasSubKeys()) {
                        sub = sub.getSubKeys().iterator().next();
                    }
                    if ((child = this.parseNode(sub, context)) == null) continue;
                    children.add(child);
                }
                elseBehavior = children.size() == 1 ? (Behavior)children.get(0) : Sequence.createSequence(children);
            } else {
                String value = elseKey.getString("");
                if (value != null && !value.isEmpty()) {
                    elseBehavior = this.parseLeaf(value, null, context);
                }
            }
        }
        return IfElse.create(condition, ifBehavior, elseBehavior);
    }

    private String[] parseInlineArgs(String input) {
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (escaped) {
                current.append(c);
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (!(inQuotes || c != '\"' && c != '\'' && c != '`')) {
                inQuotes = true;
                quoteChar = c;
                if (c != '`') continue;
                current.append(c);
                continue;
            }
            if (inQuotes && c == quoteChar) {
                inQuotes = false;
                quoteChar = '\u0000';
                if (c != '`') continue;
                current.append(c);
                continue;
            }
            if (!inQuotes && Character.isWhitespace(c)) {
                if (current.length() <= 0) continue;
                args.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            args.add(current.toString());
        }
        return args.toArray(new String[0]);
    }

    private Behavior parseLeaf(String name, DataKey params, BehaviorRegistry.BehaviorContext context) {
        if (name == null || name.isEmpty()) {
            return EMPTY;
        }
        if (name.startsWith("/")) {
            return this.createCommandBehavior(name.substring(1), context);
        }
        if (name.startsWith("`")) {
            return this.createExpressionBehavior(name, context);
        }
        String[] parts = this.parseInlineArgs(name);
        String behaviorName = parts[0];
        if (parts.length > 1) {
            String[] args = new String[parts.length - 1];
            System.arraycopy(parts, 1, args, 0, parts.length - 1);
            context.setArgs(args);
        } else {
            context.setArgs(null);
        }
        Behavior behavior = this.registry.createBehavior(behaviorName, params, context);
        if (behavior == null) {
            Messaging.severe("Unknown behavior", behaviorName);
            return EMPTY;
        }
        return behavior;
    }

    private Behavior parseNode(DataKey key, BehaviorRegistry.BehaviorContext context) {
        if (key.hasSubKeys()) {
            DataKey ifKey = null;
            DataKey elseKey = null;
            for (DataKey sub : key.getSubKeys()) {
                String name = sub.name();
                if (name.startsWith("if ")) {
                    ifKey = sub;
                    continue;
                }
                if (!name.equals("else")) continue;
                elseKey = sub;
            }
            if (ifKey != null) {
                return this.parseIfElse(ifKey, elseKey, context);
            }
            return this.parseContainer(key.name(), key, context);
        }
        String value = key.getString("");
        if (value != null && !value.isEmpty()) {
            return this.parseLeaf(value, null, context);
        }
        return this.parseLeaf(key.name(), key, context);
    }
}

