/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.hpastar;

import ch.ethz.globis.phtree.PhTreeSolid;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.hpastar.AStarSolution;
import net.citizensnpcs.api.hpastar.HPACluster;
import net.citizensnpcs.api.hpastar.HPAGraphAStarNode;
import net.citizensnpcs.api.hpastar.HPAGraphEdge;
import net.citizensnpcs.api.hpastar.HPAGraphNode;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class HPAGraph {
    private final BlockSource blockSource;
    public List<List<HPACluster>> clusters = new ArrayList<List<HPACluster>>();
    private final int cx;
    private final int cy;
    private final int cz;
    private final LongOpenHashSet dirtyRegionKeys = new LongOpenHashSet();
    private final LongOpenHashSet loadedRegionKeys = new LongOpenHashSet();
    private final List<PhTreeSolid<HPACluster>> phtrees = new ArrayList<PhTreeSolid<HPACluster>>();
    private static final int BASE_CLUSTER_HEIGHT = 8;
    private static final int BASE_CLUSTER_SIZE = 16;
    private static final float DIAGONAL_WEIGHT = (float)Math.sqrt(2.0);
    private static final float[] INTRA_NEIGHBOUR_COSTS;
    private static final int[][] INTRA_NEIGHBOUR_OFFSETS;
    private static final int MAX_CLUSTER_SIZE = 64;
    private static final int MAX_DEPTH = 3;
    private static final int MAX_WORLD_Y = 255;

    public HPAGraph(BlockSource blockSource, int cx, int cy, int cz) {
        this.blockSource = blockSource;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        while (this.clusters.size() <= 3) {
            this.clusters.add(new ArrayList());
            if (this.clusters.size() == this.phtrees.size()) continue;
            this.phtrees.add((PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
    }

    public void addClusters(int x, int z) {
        int regionZ;
        int regionX = Math.floorDiv(x - this.cx, 64);
        long regionKey = HPAGraph.packRegionKey(regionX, regionZ = Math.floorDiv(z - this.cz, 64));
        if (this.loadedRegionKeys.contains(regionKey)) {
            Messaging.debug("Clusters already exist for region:", regionX, regionZ);
            return;
        }
        int baseX = regionX * 64 + this.cx;
        int baseZ = regionZ * 64 + this.cz;
        PhTreeSolid<HPACluster> baseLevel = this.phtrees.get(0);
        Messaging.debug("Building clusters for:", baseX, baseZ);
        ArrayList<HPACluster> delta = new ArrayList<HPACluster>();
        int clusterSize = 16;
        int clusterHeight = 8;
        for (int y = 0; y <= 255; y += clusterHeight) {
            for (int ci = 0; ci < 64; ci += clusterSize) {
                for (int cj = 0; cj < 64; cj += clusterSize) {
                    HPACluster cluster = new HPACluster(this, 0, clusterSize, clusterHeight, baseX + ci, y, baseZ + cj);
                    if (!cluster.hasWalkableNodes()) continue;
                    delta.add(cluster);
                    baseLevel.put(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize}, (Object)cluster);
                    Messaging.debug(cluster);
                }
            }
        }
        HashSet deltaSet = new HashSet(delta);
        for (HPACluster cluster : delta) {
            PhTreeSolid.PhQueryS q = baseLevel.queryIntersect(new long[]{cluster.clusterX - clusterSize, cluster.clusterY - clusterHeight, cluster.clusterZ - clusterSize}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize});
            while (q.hasNext()) {
                HPACluster neighbour = (HPACluster)q.nextValue();
                if (neighbour == cluster || deltaSet.contains(neighbour) && (cluster.clusterX > neighbour.clusterX || cluster.clusterX == neighbour.clusterX && (cluster.clusterY > neighbour.clusterY || cluster.clusterY == neighbour.clusterY && cluster.clusterZ > neighbour.clusterZ))) continue;
                int dx = neighbour.clusterX - cluster.clusterX;
                int dy = neighbour.clusterY - cluster.clusterY;
                int dz = neighbour.clusterZ - cluster.clusterZ;
                if (dx == clusterSize && dy == 0 && dz == 0) {
                    cluster.connect(neighbour, HPACluster.Direction.EAST);
                    Messaging.debug("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (dx == -clusterSize && dy == 0 && dz == 0) {
                    cluster.connect(neighbour, HPACluster.Direction.WEST);
                    Messaging.debug("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (dz == clusterSize && dx == 0 && dy == 0) {
                    cluster.connect(neighbour, HPACluster.Direction.NORTH);
                    Messaging.debug("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (dz == -clusterSize && dx == 0 && dy == 0) {
                    cluster.connect(neighbour, HPACluster.Direction.SOUTH);
                    Messaging.debug("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (dy == clusterHeight && dx == 0 && dz == 0) {
                    cluster.connect(neighbour, HPACluster.Direction.UP);
                    Messaging.debug("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (dy == -clusterHeight && dx == 0 && dz == 0) {
                    cluster.connect(neighbour, HPACluster.Direction.DOWN);
                    Messaging.debug("CONNECTED", cluster, neighbour);
                    continue;
                }
                if (Math.abs(dx) != clusterSize || Math.abs(dz) != clusterSize || dy != 0) continue;
                cluster.connectDiagonal(neighbour, Integer.signum(dx), Integer.signum(dz), DIAGONAL_WEIGHT);
                Messaging.debug("CONNECTED DIAGONAL", cluster, neighbour);
            }
        }
        for (HPACluster cluster : delta) {
            cluster.connectIntra();
        }
        this.clusters.get(0).addAll(delta);
        for (int depth = 1; depth <= 3; ++depth) {
            delta = new ArrayList();
            clusterSize = 16 << depth;
            clusterHeight = 8 << depth;
            for (int y = 0; y <= 255; y += clusterHeight) {
                for (int ci = 0; ci < 64; ci += clusterSize) {
                    for (int cj = 0; cj < 64; cj += clusterSize) {
                        HPACluster cluster = new HPACluster(this, depth, clusterSize, clusterHeight, baseX + ci, y, baseZ + cj);
                        ArrayList parentClusters = Lists.newArrayList((Iterator)this.phtrees.get(depth - 1).queryInclude(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize}));
                        if (parentClusters.size() == 0) continue;
                        cluster.buildFrom(parentClusters);
                        this.phtrees.get(depth).put(new long[]{cluster.clusterX, cluster.clusterY, cluster.clusterZ}, new long[]{cluster.clusterX + clusterSize, cluster.clusterY + clusterHeight, cluster.clusterZ + clusterSize}, (Object)cluster);
                        Messaging.debug(cluster);
                        delta.add(cluster);
                    }
                }
            }
            this.clusters.get(depth).addAll(delta);
        }
        this.loadedRegionKeys.add(regionKey);
    }

    public synchronized void applyPendingPatches() {
        if (this.dirtyRegionKeys.isEmpty()) {
            return;
        }
        LongOpenHashSet dirty = new LongOpenHashSet((LongCollection)this.loadedRegionKeys);
        dirty.addAll((LongCollection)this.dirtyRegionKeys);
        this.dirtyRegionKeys.clear();
        this.reloadRegions(dirty);
    }

    private void clearGraphStorage() {
        for (int depth = 0; depth <= 3; ++depth) {
            this.clusters.set(depth, new ArrayList());
            this.phtrees.set(depth, (PhTreeSolid<HPACluster>)PhTreeSolid.create((int)3));
        }
        this.loadedRegionKeys.clear();
    }

    public Plan findPath(Location start, Location goal) {
        ArrayList<HPACluster> clustersToClean = new ArrayList<HPACluster>();
        HPAGraphNode startNode = new HPAGraphNode(start.getBlockX(), start.getBlockY(), start.getBlockZ());
        HPAGraphNode goalNode = new HPAGraphNode(goal.getBlockX(), goal.getBlockY(), goal.getBlockZ());
        HPACluster startCluster = this.getClusterAt(0, startNode.x, startNode.y, startNode.z);
        HPACluster goalCluster = this.getClusterAt(0, goalNode.x, goalNode.y, goalNode.z);
        if (startCluster == null || goalCluster == null) {
            Path path = new Path(Collections.emptyList());
            Messaging.debug("HPA returning empty path", start, "->", goal, "(missing cluster)");
            return path;
        }
        startCluster.insert(startNode);
        clustersToClean.add(startCluster);
        if (goalCluster != startCluster) {
            goalCluster.insert(goalNode);
            clustersToClean.add(goalCluster);
        } else if (!goalNode.equals(startNode)) {
            startCluster.insert(goalNode);
        }
        AStarSolution sln = this.pathfind(startNode, goalNode, 0);
        Messaging.debug("HPA path", start, "->", goal, "@", Float.valueOf(sln.cost));
        for (HPACluster cluster : clustersToClean) {
            cluster.remove(startNode, goalNode);
        }
        LazyHPAPath path = new LazyHPAPath(sln, this);
        Messaging.debug("HPA returning path", start, "->", goal, "@", Float.valueOf(sln.cost));
        return path;
    }

    private HPACluster getClusterAt(int depth, int x, int y, int z) {
        PhTreeSolid.PhQueryS q = this.phtrees.get(depth).queryIntersect(new long[]{x, y, z}, new long[]{x, y, z});
        return q.hasNext() ? (HPACluster)q.next() : null;
    }

    public void invalidateRegion(int x, int z) {
        LongOpenHashSet regionsToReload = new LongOpenHashSet((LongCollection)this.loadedRegionKeys);
        regionsToReload.add(this.regionKeyFromBlock(x, z));
        this.reloadRegions(regionsToReload);
    }

    public synchronized void markDirtyBlock(int x, int z) {
        this.dirtyRegionKeys.add(this.regionKeyFromBlock(x, z));
    }

    public synchronized void markDirtyChunk(int chunkX, int chunkZ) {
        this.markDirtyBlock(chunkX << 4, chunkZ << 4);
    }

    AStarSolution pathfind(HPAGraphNode start, HPAGraphNode dest, int level) {
        if (start.equals(dest)) {
            return new AStarSolution(Lists.newArrayList((Object[])new HPAGraphAStarNode[]{new HPAGraphAStarNode(start, null)}), 0.0f);
        }
        Long2FloatOpenHashMap open = new Long2FloatOpenHashMap();
        Long2FloatOpenHashMap closed = new Long2FloatOpenHashMap();
        open.defaultReturnValue(Float.POSITIVE_INFINITY);
        closed.defaultReturnValue(Float.POSITIVE_INFINITY);
        PriorityQueue<HPAGraphAStarNode> frontier = new PriorityQueue<HPAGraphAStarNode>();
        HPAGraphAStarNode startNode = new HPAGraphAStarNode(start, null);
        frontier.add(startNode);
        open.put(HPAGraph.packPosition(start.x, start.y, start.z), startNode.g);
        while (!frontier.isEmpty()) {
            HPAGraphAStarNode node = (HPAGraphAStarNode)frontier.poll();
            long nodeKey = HPAGraph.packPosition(node.node.x, node.node.y, node.node.z);
            float bestOpen = open.get(nodeKey);
            if (!Float.isFinite(bestOpen) || node.g > bestOpen) continue;
            List<HPAGraphEdge> edges = node.node.getEdges(level);
            if (start != node.node) {
                closed.put(nodeKey, node.g);
            }
            open.remove(nodeKey);
            for (HPAGraphEdge edge : edges) {
                float tentativeG = node.g + edge.weight;
                long neighbourKey = HPAGraph.packPosition(edge.to.x, edge.to.y, edge.to.z);
                float closedG = closed.get(neighbourKey);
                if (tentativeG >= closedG) continue;
                if (Float.isFinite(closedG)) {
                    closed.remove(neighbourKey);
                }
                if (tentativeG >= open.get(neighbourKey)) continue;
                HPAGraphAStarNode neighbour = new HPAGraphAStarNode(edge.to, edge);
                neighbour.parent = node;
                neighbour.g = tentativeG;
                neighbour.h = HPAGraph.euclidean(edge.to.x, edge.to.y, edge.to.z, dest.x, dest.y, dest.z);
                if (edge.to.equals(dest)) {
                    return new AStarSolution(neighbour.reconstructSolution(), neighbour.g);
                }
                open.put(neighbourKey, neighbour.g);
                frontier.add(neighbour);
            }
        }
        return new AStarSolution(null, Float.POSITIVE_INFINITY);
    }

    private long regionKeyFromBlock(int x, int z) {
        return HPAGraph.packRegionKey(Math.floorDiv(x - this.cx, 64), Math.floorDiv(z - this.cz, 64));
    }

    private void reloadRegions(LongOpenHashSet regionKeys) {
        this.clearGraphStorage();
        LongIterator it = regionKeys.iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            this.addClusters((int)(key >> 32) * 64 + this.cx, (int)key * 64 + this.cz);
        }
    }

    public boolean walkable(int x, int y, int z) {
        if (!(this.blockSource.isYWithinBounds(y - 1) && this.blockSource.isYWithinBounds(y) && this.blockSource.isYWithinBounds(y + 1))) {
            return false;
        }
        return MinecraftBlockExaminer.canStandIn(this.blockSource.getMaterialAt(x, y, z)) && MinecraftBlockExaminer.canStandIn(this.blockSource.getMaterialAt(x, y + 1, z)) && MinecraftBlockExaminer.canStandOn(this.blockSource.getMaterialAt(x, y - 1, z));
    }

    private static float euclidean(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static long packPosition(int x, int y, int z) {
        return ((long)x & 0x3FFFFFFL) << 34 | ((long)z & 0x3FFFFFFL) << 8 | (long)y & 0xFFL;
    }

    private static long packRegionKey(int regionX, int regionZ) {
        return (long)regionX << 32 ^ (long)regionZ & 0xFFFFFFFFL;
    }

    static {
        int[][] neighbours = new int[26][3];
        int index = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    neighbours[index][0] = dx;
                    neighbours[index][1] = dy;
                    neighbours[index][2] = dz;
                    ++index;
                }
            }
        }
        INTRA_NEIGHBOUR_OFFSETS = neighbours;
        float[] costs = new float[INTRA_NEIGHBOUR_OFFSETS.length];
        for (int i = 0; i < INTRA_NEIGHBOUR_OFFSETS.length; ++i) {
            int dx = INTRA_NEIGHBOUR_OFFSETS[i][0];
            int dy = INTRA_NEIGHBOUR_OFFSETS[i][1];
            int dz = INTRA_NEIGHBOUR_OFFSETS[i][2];
            costs[i] = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        }
        INTRA_NEIGHBOUR_COSTS = costs;
    }

    private static class LazyHPAPath
    extends Path {
        private int abstractIndex = 1;
        private final List<HPAGraphAStarNode> clusterPath;
        private final List<Vector> concretePath = new ArrayList<Vector>();
        private final HPAGraph graph;
        private int index = 0;

        private LazyHPAPath(AStarSolution solution, HPAGraph graph) {
            super(Collections.emptyList());
            this.graph = graph;
            List<Object> list = this.clusterPath = solution.path == null ? Collections.emptyList() : solution.path;
            if (!this.clusterPath.isEmpty()) {
                this.concretePath.add(this.clusterPath.get((int)0).node.toVector());
            }
        }

        private void appendUnique(Vector vector) {
            Vector last = this.concretePath.get(this.concretePath.size() - 1);
            if (!last.equals((Object)vector)) {
                this.concretePath.add(vector);
            }
        }

        private void concretize() {
            while (this.abstractIndex < this.clusterPath.size()) {
                this.concretizeNextSegment();
            }
        }

        private void concretizeNextSegment() {
            HPAGraphAStarNode current;
            HPAGraphEdge edge;
            if ((edge = (current = this.clusterPath.get(this.abstractIndex++)).getEdge()) != null && edge.type == HPAGraphEdge.EdgeType.INTRA) {
                for (Vector vector : this.intraPathfind(edge.from, edge.to)) {
                    this.appendUnique(vector);
                }
            } else {
                this.appendUnique(current.node.toVector());
            }
        }

        private void concretizeToIndex(int targetIndex) {
            while (this.concretePath.size() <= targetIndex && this.abstractIndex < this.clusterPath.size()) {
                this.concretizeNextSegment();
            }
        }

        @Override
        public List<Block> getBlocks(World world) {
            this.concretize();
            return this.concretePath.stream().map(v -> world.getBlockAt(v.getBlockX(), v.getBlockY(), v.getBlockZ())).collect(Collectors.toList());
        }

        @Override
        public Vector getCurrentVector() {
            this.concretizeToIndex(this.index);
            return this.concretePath.get(this.index);
        }

        @Override
        public Iterable<Vector> getPath() {
            this.concretize();
            return new ArrayList<Vector>(this.concretePath);
        }

        private List<Vector> intraPathfind(HPAGraphNode from, HPAGraphNode to) {
            if (from.equals(to)) {
                return ImmutableList.of((Object)from.toVector());
            }
            HPACluster cluster = this.graph.getClusterAt(0, from.x, from.y, from.z);
            if (cluster == null || !cluster.containsPoint(to.x, to.y, to.z)) {
                cluster = this.graph.getClusterAt(0, to.x, to.y, to.z);
            }
            if (cluster == null || !cluster.containsPoint(from.x, from.y, from.z) || !cluster.containsPoint(to.x, to.y, to.z)) {
                return ImmutableList.of((Object)from.toVector(), (Object)to.toVector());
            }
            Long2FloatOpenHashMap open = new Long2FloatOpenHashMap();
            Long2FloatOpenHashMap closed = new Long2FloatOpenHashMap();
            open.defaultReturnValue(Float.POSITIVE_INFINITY);
            closed.defaultReturnValue(Float.POSITIVE_INFINITY);
            PriorityQueue<LocalPathNode> frontier = new PriorityQueue<LocalPathNode>();
            LocalPathNode startNode = new LocalPathNode(from.x, from.y, from.z, 0.0f, HPAGraph.euclidean(from.x, from.y, from.z, to.x, to.y, to.z), null);
            frontier.add(startNode);
            open.put(HPAGraph.packPosition(from.x, from.y, from.z), 0.0f);
            while (!frontier.isEmpty()) {
                LocalPathNode node = (LocalPathNode)frontier.poll();
                long nodeKey = HPAGraph.packPosition(node.x, node.y, node.z);
                float bestOpen = open.get(nodeKey);
                if (!Float.isFinite(bestOpen) || node.g > bestOpen) continue;
                if (node.x == to.x && node.y == to.y && node.z == to.z) {
                    ArrayList<Vector> path = new ArrayList<Vector>();
                    while (node != null) {
                        path.add(new Vector(node.x, node.y, node.z));
                        node = node.parent;
                    }
                    Collections.reverse(path);
                    return path;
                }
                if (node.x != from.x || node.y != from.y || node.z != from.z) {
                    closed.put(nodeKey, node.g);
                }
                open.remove(nodeKey);
                for (int i = 0; i < INTRA_NEIGHBOUR_OFFSETS.length; ++i) {
                    float closedG;
                    boolean isGoal;
                    int nz;
                    int ny;
                    int nx = node.x + INTRA_NEIGHBOUR_OFFSETS[i][0];
                    if (!cluster.containsPoint(nx, ny = node.y + INTRA_NEIGHBOUR_OFFSETS[i][1], nz = node.z + INTRA_NEIGHBOUR_OFFSETS[i][2])) continue;
                    boolean bl = isGoal = nx == to.x && ny == to.y && nz == to.z;
                    if (!isGoal && !this.graph.walkable(nx, ny, nz)) continue;
                    long neighbourKey = HPAGraph.packPosition(nx, ny, nz);
                    float tentativeG = node.g + INTRA_NEIGHBOUR_COSTS[i];
                    if (tentativeG >= (closedG = closed.get(neighbourKey))) continue;
                    if (Float.isFinite(closedG)) {
                        closed.remove(neighbourKey);
                    }
                    if (tentativeG >= open.get(neighbourKey)) continue;
                    LocalPathNode neighbour = new LocalPathNode(nx, ny, nz, tentativeG, HPAGraph.euclidean(nx, ny, nz, to.x, to.y, to.z), node);
                    open.put(neighbourKey, neighbour.g);
                    frontier.add(neighbour);
                }
            }
            return ImmutableList.of((Object)from.toVector(), (Object)to.toVector());
        }

        @Override
        public boolean isComplete() {
            this.concretizeToIndex(this.index);
            return this.abstractIndex >= this.clusterPath.size() && this.index >= this.concretePath.size();
        }

        @Override
        public void run(NPC npc) {
        }

        @Override
        public String toString() {
            this.concretize();
            return this.concretePath.toString();
        }

        @Override
        public void update(Agent agent) {
            if (this.isComplete()) {
                return;
            }
            ++this.index;
        }
    }

    private static class LocalPathNode
    implements Comparable<LocalPathNode> {
        final float g;
        final float h;
        final LocalPathNode parent;
        final int x;
        final int y;
        final int z;

        private LocalPathNode(int x, int y, int z, float g, float h, LocalPathNode parent) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.g = g;
            this.h = h;
            this.parent = parent;
        }

        @Override
        public int compareTo(LocalPathNode other) {
            return Float.compare(this.g + this.h, other.g + other.h);
        }
    }
}

