/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_19_R3.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_19_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_19_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_19_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.Position;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.entity.vehicle.EntityMinecartTNT;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class MinecartTNTController
extends MobEntityController {
    public MinecartTNTController() {
        super(EntityMinecartTNTNPC.class);
    }

    public Minecart getBukkitEntity() {
        return (Minecart)super.getBukkitEntity();
    }

    public static class EntityMinecartTNTNPC
    extends EntityMinecartTNT
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityMinecartTNTNPC(EntityTypes<? extends EntityMinecartTNT> types, World level) {
            this(types, level, null);
        }

        public EntityMinecartTNTNPC(EntityTypes<? extends EntityMinecartTNT> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction C_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.C_();
        }

        public boolean bn() {
            return this.npc == null ? super.bn() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        protected AxisAlignedBB am() {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.am());
        }

        public void j(double x, double y, double z) {
            Vector vector = Util.callPushEvent((NPC)this.npc, (double)x, (double)y, (double)z);
            if (vector != null) {
                super.j(vector.getX(), vector.getY(), vector.getZ());
            }
        }

        public void g(net.minecraft.world.entity.Entity entity) {
            super.g(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Position location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void l() {
            super.l();
            if (this.npc != null) {
                this.npc.update();
                NMSImpl.minecartItemLogic((EntityMinecartAbstract)this);
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dj().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.f(old);
            }
            return res;
        }
    }
}

