/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R5.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_21_R5.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_21_R5.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_21_R5.util.EntityNavigation;
import net.citizensnpcs.nms.v1_21_R5.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public cgj getJumpControl();

    public Map<fbc, Float> getMalus();

    public cgl getMoveControl();

    public cjw getNavigation();

    default public float getPathfindingMalus(fbc var1) {
        Map<fbc, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(fbc water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        cjw nav = this.getNavigation();
        if (!nav.l()) {
            nav.d();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((cam)NMSImpl.getHandle(this.getBukkitEntity())).h(cbs.n).a((double)range);
    }

    public static MobAI from(bzm handle) {
        if (handle instanceof cao) {
            final cao mob = (cao)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public cgj getJumpControl() {
                    return mob.R();
                }

                @Override
                public Map<fbc, Float> getMalus() {
                    return null;
                }

                @Override
                public cgl getMoveControl() {
                    return mob.Q();
                }

                @Override
                public cjw getNavigation() {
                    return mob.S();
                }

                @Override
                public float getPathfindingMalus(fbc var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(fbc water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.T().a();
                    mob.S().d();
                    mob.Q().a();
                    mob.P().a();
                    mob.R().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public cgj getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<fbc, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public cgl getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public cjw getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final cam entity;
        private final Map<fbc, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(cam entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (jl<cbn>)cbs.n, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.h(cbs.w).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.ai());
            this.malus = Maps.newEnumMap(fbc.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public cgj getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<fbc, Float> getMalus() {
            return this.malus;
        }

        @Override
        public cgl getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public cjw getNavigation() {
            return this.navigation;
        }
    }
}

