/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.entity.nonliving;

import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.nms.v1_21_R6.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R6.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.AbstractEntityController;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftEntity;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class BoatController
extends AbstractEntityController {
    protected Entity createEntity(Location at, NPC npc) {
        EntityTypes type = EntityTypes.aL;
        dhl item = dht.pr;
        switch (((MobType)npc.getOrAddTrait(MobType.class)).getType()) {
            case ACACIA_BOAT: {
                type = EntityTypes.c;
                item = dht.pz;
                break;
            }
            case BIRCH_BOAT: {
                type = EntityTypes.o;
                item = dht.pv;
                break;
            }
            case CHERRY_BOAT: {
                type = EntityTypes.y;
                item = dht.pB;
                break;
            }
            case DARK_OAK_BOAT: {
                type = EntityTypes.I;
                item = dht.pD;
                break;
            }
            case JUNGLE_BOAT: {
                type = EntityTypes.ax;
                item = dht.px;
                break;
            }
            case MANGROVE_BOAT: {
                type = EntityTypes.aE;
                item = dht.pH;
                break;
            }
            case OAK_BOAT: {
                break;
            }
            case SPRUCE_BOAT: {
                type = EntityTypes.bu;
                item = dht.pt;
                break;
            }
        }
        dhl fitem = item;
        EntityBoatNPC handle = new EntityBoatNPC((EntityTypes<? extends EntityBoat>)type, (World)((CraftWorld)at.getWorld()).getHandle(), () -> fitem, npc);
        return handle.getBukkitEntity();
    }

    public Boat getBukkitEntity() {
        return (Boat)super.getBukkitEntity();
    }

    public static class EntityBoatNPC
    extends EntityBoat
    implements NPCHolder {
        private float invFriction;
        private float landFriction;
        private dby.EnumStatus lastStatus;
        private final CitizensNPC npc;
        private dby.EnumStatus status;
        private double waterLevel;

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> types, World level, Supplier<dhl> supplier) {
            this(types, level, supplier, null);
        }

        public EntityBoatNPC(EntityTypes<? extends EntityBoat> types, World level, Supplier<dhl> supplier, NPC npc) {
            super(types, level, supplier);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
        }

        private boolean checkInWater() {
            AxisAlignedBB axisalignedbb = this.de();
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k2 = MathHelper.a((double)axisalignedbb.b);
            int l = MathHelper.c((double)(axisalignedbb.b + 0.001));
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            this.waterLevel = -1.7976931348623157E308;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k2; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        FluidType fluid = this.an().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a)) continue;
                        float f = (float)l1 + fluid.a((IBlockAccess)this.an(), (BlockPosition)blockposition_mutableblockposition);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.b < (double)f;
                    }
                }
            }
            return flag;
        }

        private void floatBoat() {
            double d0 = -this.bp();
            double d1 = 0.0;
            this.invFriction = 0.05f;
            if (this.lastStatus == dby.EnumStatus.e && this.status != dby.EnumStatus.e && this.status != dby.EnumStatus.d) {
                this.waterLevel = this.f(1.0);
                double d2 = (double)(this.i() - this.dB()) + 0.101;
                if (this.an().a((cdv)this, this.de().d(0.0, d2 - this.dM(), 0.0))) {
                    this.a(EnumMoveType.a, new Vec3D(0.0, d2 - this.dM(), 0.0));
                    this.k(this.dI().d(1.0, 0.0, 1.0));
                }
                this.status = dby.EnumStatus.a;
            } else {
                if (this.status == dby.EnumStatus.a) {
                    d1 = (this.waterLevel - this.dM()) / (double)this.dB();
                    this.invFriction = 0.9f;
                } else if (this.status == dby.EnumStatus.c) {
                    d0 = -7.0E-4;
                    this.invFriction = 0.9f;
                } else if (this.status == dby.EnumStatus.b) {
                    d1 = 0.01f;
                    this.invFriction = 0.45f;
                } else if (this.status == dby.EnumStatus.e) {
                    this.invFriction = 0.9f;
                } else if (this.status == dby.EnumStatus.d) {
                    this.invFriction = this.landFriction;
                    if (this.dg() instanceof Player) {
                        this.landFriction /= 2.0f;
                    }
                }
                Vec3D vec3d = this.dI();
                this.m(vec3d.g * (double)this.invFriction, vec3d.h + d0, vec3d.i * (double)this.invFriction);
                if (d1 > 0.0) {
                    Vec3D vec3d1 = this.dI();
                    this.m(vec3d1.g, (vec3d1.h + d1 * (this.bo() / 0.65)) * 0.75, vec3d1.i);
                }
            }
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((cdv)this, (CraftEntity)new BoatNPC(this));
            }
            return super.getBukkitEntity();
        }

        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction p_() {
            return Util.callPistonPushEvent((NPC)this.npc) ? EnumPistonReaction.d : super.p_();
        }

        private dby.EnumStatus getStatus() {
            dby.EnumStatus entityboat_Status = this.isUnderwater();
            if (entityboat_Status != null) {
                this.waterLevel = this.de().e;
                return entityboat_Status;
            }
            if (this.checkInWater()) {
                return dby.EnumStatus.a;
            }
            float f = this.k();
            if (f > 0.0f) {
                this.landFriction = f;
                return dby.EnumStatus.d;
            }
            return dby.EnumStatus.e;
        }

        public boolean bU() {
            return this.npc == null ? super.bU() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
        }

        private dby.EnumStatus isUnderwater() {
            AxisAlignedBB axisalignedbb = this.de();
            double d0 = axisalignedbb.e + 0.001;
            int i = MathHelper.a((double)axisalignedbb.a);
            int j = MathHelper.c((double)axisalignedbb.d);
            int k2 = MathHelper.a((double)axisalignedbb.e);
            int l = MathHelper.c((double)d0);
            int i1 = MathHelper.a((double)axisalignedbb.c);
            int j1 = MathHelper.c((double)axisalignedbb.f);
            boolean flag = false;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k2; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockposition_mutableblockposition.d(k1, l1, i2);
                        FluidType fluid = this.an().b_((BlockPosition)blockposition_mutableblockposition);
                        if (!fluid.a(TagsFluid.a) || !(d0 < (double)((float)blockposition_mutableblockposition.v() + fluid.a((IBlockAccess)this.an(), (BlockPosition)blockposition_mutableblockposition)))) continue;
                        if (!fluid.b()) {
                            return dby.EnumStatus.c;
                        }
                        flag = true;
                    }
                }
            }
            return flag ? dby.EnumStatus.b : null;
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB((NPC)this.npc, super.c(vec3));
        }

        public void h(cdv entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public void l_() {
            if (this.npc == null) {
                super.l_();
            } else {
                NMSImpl.setSize((cdv)this, this.ay);
            }
        }

        public boolean c(fir save) {
            return this.npc == null ? super.c(save) : false;
        }

        public cdv b(fha transition) {
            if (this.npc == null || transition.b().al().equals(this.an().al())) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((cdv)this, transition);
        }

        public void g() {
            if (this.npc == null) {
                super.g();
                return;
            }
            this.aH();
            if (this.az.a()) {
                for (Player p : CitizensAPI.getLocationLookup().getNearbyPlayers(this.getBukkitEntity().getLocation(), 64.0)) {
                    NMSImpl.sendPacket(p, new PacketPlayOutEntityMetadata(this.az(), this.az.b()));
                }
            }
            if (this.dg() instanceof NPCHolder && ((NPCHolder)this.dg()).getNPC().getNavigator().isNavigating()) {
                this.k(this.dg().dI().d(20.0, 0.0, 20.0));
            }
            this.npc.update();
            if (this.H() > 0) {
                this.d(this.H() - 1);
            }
            if (this.G() > 0.0f) {
                this.a(this.G() - 1.0f);
            }
            this.lastStatus = this.status;
            this.status = this.getStatus();
            this.floatBoat();
            this.a(EnumMoveType.a, this.dI());
            this.aT();
        }

        public boolean a(bdj<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dI().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.k(old);
            }
            return res;
        }
    }

    public static class BoatNPC
    extends CraftBoat
    implements ForwardingNPCHolder {
        public BoatNPC(EntityBoatNPC entity) {
            super((CraftServer)Bukkit.getServer(), (dby)entity);
        }
    }
}

