/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class PlayerAnimationImpl {
    private static final Map<PlayerAnimation, Integer> DEFAULTS = Maps.newEnumMap(PlayerAnimation.class);

    public static void play(PlayerAnimation animation, Player bplayer, Iterable<Player> to) {
        awy player = (awy)NMSImpl.getHandle((Entity)bplayer);
        if (DEFAULTS.containsKey(animation)) {
            PlayerAnimationImpl.playDefaultAnimation(player, to, DEFAULTS.get(animation));
            return;
        }
        switch (animation) {
            case HURT: {
                PlayerAnimationImpl.sendPacketNearby(new aef((cew)player), to);
                break;
            }
            case SNEAK: {
                player.c(cfi.f);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case START_ELYTRA: {
                player.gJ();
                break;
            }
            case STOP_ELYTRA: {
                player.fB();
                break;
            }
            case START_USE_MAINHAND_ITEM: {
                player.c(cbp.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fR()));
                break;
            }
            case START_USE_OFFHAND_ITEM: {
                player.c(cbp.b);
                PlayerAnimationImpl.sendEntityData(to, player);
                player.getBukkitEntity().setMetadata("citizens-using-item-remaining-ticks", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)player.fR()));
                break;
            }
            case STOP_SNEAKING: {
                player.c(cfi.a);
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            case STOP_USE_ITEM: {
                player.fU();
                PlayerAnimationImpl.sendEntityData(to, player);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    protected static void playDefaultAnimation(awy player, Iterable<Player> to, int code) {
        act packet = new act((cdv)player, code);
        PlayerAnimationImpl.sendPacketNearby(packet, to);
    }

    private static void sendEntityData(Iterable<Player> to, awy player) {
        if (!player.aC().a()) {
            return;
        }
        PlayerAnimationImpl.sendPacketNearby(new agf(player.az(), player.aC().b()), to);
    }

    protected static void sendPacketNearby(aao<?> packet, Iterable<Player> to) {
        for (Player player : to) {
            NMSImpl.sendPacket(player, packet);
        }
    }

    static {
        DEFAULTS.put(PlayerAnimation.ARM_SWING, 0);
        DEFAULTS.put(PlayerAnimation.LEAVE_BED, 2);
        DEFAULTS.put(PlayerAnimation.ARM_SWING_OFFHAND, 3);
        DEFAULTS.put(PlayerAnimation.CRIT, 4);
        DEFAULTS.put(PlayerAnimation.MAGIC_CRIT, 5);
    }
}

