/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.NPCUpdater;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.exception.NPCException;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.DatabaseStorage;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.command.CommandManager;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.command.AdminCommands;
import net.citizensnpcs.command.command.EditorCommands;
import net.citizensnpcs.command.command.HelpCommands;
import net.citizensnpcs.command.command.NPCCommands;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.CommandUsageException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.command.exception.UnhandledCommandException;
import net.citizensnpcs.command.exception.WrappedCommandException;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensCharacterManager;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.CitizensTraitManager;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Metrics;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin {
    private static final String COMPATIBLE_MC_VERSION = "1.2.3";
    private final CommandManager commands = new CommandManager();
    private boolean compatible;
    private Settings config;
    private CitizensCharacterManager characterManager;
    private volatile CitizensNPCManager npcManager;
    private Storage saves;

    public CitizensCharacterManager getCharacterManager() {
        return this.characterManager;
    }

    public CommandManager getCommandManager() {
        return this.commands;
    }

    public CitizensNPCManager getNPCManager() {
        return this.npcManager;
    }

    public Storage getStorage() {
        return this.saves;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        try {
            String modifier;
            String[] split = new String[args.length + 1];
            System.arraycopy(args, 0, split, 1, args.length);
            split[0] = cmd.getName().toLowerCase();
            String string = modifier = args.length > 0 ? args[0] : "";
            if (!this.commands.hasCommand(split[0], modifier) && !modifier.isEmpty()) {
                return this.suggestClosestModifier(sender, split[0], modifier);
            }
            NPC npc = null;
            if (player != null && player.getMetadata("selected").size() > 0) {
                npc = this.npcManager.getNPC(((MetadataValue)player.getMetadata("selected").get(0)).asInt());
            }
            try {
                this.commands.execute(split, player, player == null ? sender : player, npc);
            }
            catch (ServerCommandException ex) {
                Messaging.send(sender, "You must be in-game to execute that command.");
            }
            catch (CommandUsageException ex) {
                Messaging.sendError((CommandSender)player, ex.getMessage());
                Messaging.sendError((CommandSender)player, ex.getUsage());
            }
            catch (WrappedCommandException ex) {
                throw ex.getCause();
            }
            catch (UnhandledCommandException ex) {
                return false;
            }
            catch (CommandException ex) {
                Messaging.sendError((CommandSender)player, ex.getMessage());
            }
        }
        catch (NumberFormatException ex) {
            Messaging.sendError((CommandSender)player, "That is not a valid number.");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            Messaging.sendError((CommandSender)player, "Please report this error: [See console]");
            Messaging.sendError((CommandSender)player, ex.getClass().getName() + ": " + ex.getMessage());
        }
        return true;
    }

    public void onDisable() {
        if (this.compatible) {
            this.save();
            for (NPC npc : this.npcManager) {
                npc.despawn();
            }
            this.getServer().getScheduler().cancelTasks((Plugin)this);
        }
        Messaging.log("v" + this.getDescription().getVersion() + " disabled.");
    }

    public void onEnable() {
        this.compatible = ((CraftServer)this.getServer()).getServer().getVersion().startsWith(COMPATIBLE_MC_VERSION);
        String mcVersion = ((CraftServer)this.getServer()).getServer().getVersion();
        if (!this.compatible) {
            Messaging.log(Level.SEVERE, "v" + this.getDescription().getVersion() + " is not compatible with Minecraft v" + mcVersion + ". Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.config = new Settings(this);
        this.config.load();
        if (Settings.Setting.USE_DATABASE.asBoolean()) {
            try {
                this.saves = new DatabaseStorage(Settings.Setting.DATABASE_DRIVER.asString(), Settings.Setting.DATABASE_URL.asString(), Settings.Setting.DATABASE_USERNAME.asString(), Settings.Setting.DATABASE_PASSWORD.asString());
            }
            catch (SQLException e) {
                Messaging.log("Unable to connect to database, falling back to YAML");
                this.saves = new YamlStorage(this.getDataFolder() + File.separator + "saves.yml", "Citizens NPC Storage");
            }
        } else {
            this.saves = new YamlStorage(this.getDataFolder() + File.separator + "saves.yml", "Citizens NPC Storage");
        }
        this.npcManager = new CitizensNPCManager(this.saves);
        this.characterManager = new CitizensCharacterManager();
        CitizensAPI.setNPCManager(this.npcManager);
        CitizensAPI.setCharacterManager(this.characterManager);
        CitizensAPI.setTraitManager(new CitizensTraitManager());
        this.getServer().getPluginManager().registerEvents((Listener)new EventListen(this.npcManager), (Plugin)this);
        this.registerCommands();
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new NPCUpdater(this.npcManager), 0L, 1L);
        Messaging.log("v" + this.getDescription().getVersion() + " enabled.");
        if (Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    Citizens.this.setupNPCs();
                }
                catch (NPCLoadException ex) {
                    Messaging.log(Level.SEVERE, "Issue when loading NPCs: " + ex.getMessage());
                }
            }
        }) == -1) {
            Messaging.log(Level.SEVERE, "Issue enabling plugin. Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Metrics metrics = new Metrics();
                    metrics.addCustomData((Plugin)Citizens.this, new Metrics.Plotter(){

                        @Override
                        public String getColumnName() {
                            return "Total NPCs";
                        }

                        @Override
                        public int getValue() {
                            return Iterators.size(Citizens.this.npcManager.iterator());
                        }
                    });
                    metrics.beginMeasuringPlugin((Plugin)Citizens.this);
                }
                catch (IOException ex) {
                    Messaging.log("Unable to load metrics");
                }
            }
        }.start();
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(new Object[]{this}));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(HelpCommands.class);
        this.commands.register(NPCCommands.class);
    }

    public void reload() throws NPCLoadException {
        Editor.leaveAll();
        this.config.load();
        for (NPC npc : this.npcManager) {
            npc.despawn();
        }
        this.saves.load();
        this.setupNPCs();
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    public void save() {
        this.config.save();
        for (NPC npc : this.npcManager) {
            npc.save(this.saves.getKey("npc." + npc.getId()));
        }
        this.saves.save();
    }

    private void setupNPCs() throws NPCLoadException {
        int created = 0;
        int spawned = 0;
        for (DataKey key : this.saves.getKey("npc").getIntegerSubKeys()) {
            int id = Integer.parseInt(key.name());
            if (!key.keyExists("name")) {
                throw new NPCLoadException("Could not find a name for the NPC with ID '" + id + "'.");
            }
            NPC npc = this.npcManager.createNPC(EntityType.valueOf((String)key.getString("traits.type").toUpperCase()), id, key.getString("name"), null);
            try {
                npc.load(key);
            }
            catch (NPCException ex) {
                Messaging.log(ex.getMessage());
            }
            ++created;
            if (!npc.isSpawned()) continue;
            ++spawned;
        }
        Messaging.log("Loaded " + created + " NPCs (" + spawned + " spawned).");
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        String closest = "";
        for (String string : this.commands.getAllCommandModifiers(command)) {
            int distance = StringHelper.getLevenshteinDistance(modifier, string);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = string;
        }
        if (!closest.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "Unknown command. Did you mean:");
            sender.sendMessage(StringHelper.wrap(" /") + command + " " + StringHelper.wrap(closest));
            return true;
        }
        return false;
    }
}

