/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.SpawnLocation;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class AbstractNPC
implements NPC {
    private Character character;
    private final int id;
    private String name;
    private final List<Runnable> runnables = new ArrayList<Runnable>();
    private final Map<Class<? extends Trait>, Trait> traits = new HashMap<Class<? extends Trait>, Trait>();
    private static final MetadataStoreBase<NPC> METADATA = new MetadataStoreBase<NPC>(){

        protected String disambiguate(NPC subject, String metadataKey) {
            return Integer.toString(subject.getId()) + ":" + subject.getName() + ":" + metadataKey;
        }
    };

    protected AbstractNPC(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait instanceof Runnable) {
            this.runnables.add((Runnable)((Object)trait));
            if (this.traits.containsKey(trait.getClass())) {
                this.runnables.remove(this.traits.get(trait.getClass()));
            }
        }
        this.traits.put(trait.getClass(), trait);
    }

    @Override
    public Character getCharacter() {
        return this.character;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public List<MetadataValue> getMetadata(String key) {
        return METADATA.getMetadata((Object)this, key);
    }

    @Override
    public String getName() {
        String parsed = this.name;
        for (ChatColor color : ChatColor.values()) {
            if (!parsed.contains("<" + color.getChar() + ">")) continue;
            parsed = parsed.replace("<" + color.getChar() + ">", "");
        }
        return parsed;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        Trait t = this.traits.get(clazz);
        if (t == null) {
            this.addTrait((Trait)CitizensAPI.getTraitManager().getTrait(clazz, (NPC)this));
        }
        return (T)(this.traits.get(clazz) != null ? (Trait)clazz.cast(this.traits.get(clazz)) : null);
    }

    @Override
    public Iterable<Trait> getTraits() {
        return Collections.unmodifiableCollection(this.traits.values());
    }

    public boolean hasMetadata(String key) {
        return METADATA.hasMetadata((Object)this, key);
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public void load(DataKey root) throws NPCLoadException {
        Character character = CitizensAPI.getCharacterManager().getCharacter(root.getString("character"));
        if (character != null) {
            character.load(root.getRelative("characters." + character.getName()));
            this.setCharacter(character);
        }
        for (DataKey traitKey : root.getRelative("traits").getSubKeys()) {
            Object trait = CitizensAPI.getTraitManager().getTrait(traitKey.name(), (NPC)this);
            if (trait == null) {
                throw new NPCLoadException("No trait with the name '" + traitKey.name() + "' exists. Was it registered properly?");
            }
            try {
                ((Trait)trait).load(traitKey);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Citizens] The trait '" + traitKey.name() + "' failed to load properly for the NPC with the ID '" + this.getId() + "'. " + ex.getMessage());
                ex.printStackTrace();
            }
            this.addTrait((Trait)trait);
        }
        if (this.getTrait(Spawned.class).shouldSpawn()) {
            this.spawn(this.getTrait(SpawnLocation.class).getLocation());
        }
    }

    public void removeMetadata(String key, Plugin plugin) {
        METADATA.removeMetadata((Object)this, key, plugin);
    }

    @Override
    public void removeTrait(Class<? extends Trait> trait) {
        if (this.traits.containsKey(trait)) {
            Trait t = this.traits.get(trait);
            if (t instanceof Runnable) {
                this.runnables.remove(t);
            }
            t.onRemove(this);
        }
        this.traits.remove(trait);
    }

    @Override
    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        if (this.getCharacter() != null) {
            root.setString("character", this.getCharacter().getName());
            this.getCharacter().save(root.getRelative("characters." + this.getCharacter().getName()));
        }
        for (Trait trait : this.getTraits()) {
            trait.save(root.getRelative("traits." + trait.getName()));
        }
    }

    @Override
    public void setCharacter(Character character) {
        if (this.character != null) {
            if (this.character instanceof Runnable) {
                this.runnables.remove(this.character);
            }
            this.character.onRemove(this);
        }
        this.character = character;
        if (character != null) {
            if (character instanceof Runnable) {
                this.runnables.add((Runnable)((Object)character));
            }
            character.onSet(this);
        }
    }

    public void setMetadata(String key, MetadataValue value) {
        METADATA.setMetadata((Object)this, key, value);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void update() {
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
    }
}

