/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.util.Messaging;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class EquipmentEditor
extends Editor {
    private final NPC npc;
    private final Player player;
    private final Citizens plugin;

    public EquipmentEditor(Citizens plugin, Player player, NPC npc) {
        this.plugin = plugin;
        this.player = player;
        this.npc = npc;
    }

    @Override
    public void begin() {
        Messaging.send((CommandSender)this.player, "<b>Entered the equipment editor!");
        Messaging.send((CommandSender)this.player, "<e>Right click <a>to equip armor and items.");
        Messaging.send((CommandSender)this.player, "<e>Right click <a>while <e>crouching <a>to equip armor in the NPC's hand.");
        Messaging.send((CommandSender)this.player, "<e>Right click <a>with an <e>empty hand <a>to remove all armor and items.");
    }

    @Override
    public void end() {
        Messaging.send((CommandSender)this.player, "<a>Exited the equipment editor.");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR && Editor.hasEditor(event.getPlayer())) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        ItemStack set;
        if (!(this.plugin.getNPCManager().isNPC(event.getRightClicked()) && this.plugin.getNPCManager().getNPC(event.getRightClicked()).equals(this.npc) && event.getPlayer().equals(this.player))) {
            return;
        }
        ItemStack hand = this.player.getItemInHand();
        Equipment trait = this.npc.getTrait(Equipment.class);
        int slot = 0;
        switch (hand.getType()) {
            case PUMPKIN: 
            case JACK_O_LANTERN: 
            case LEATHER_HELMET: 
            case CHAINMAIL_HELMET: 
            case GOLD_HELMET: 
            case IRON_HELMET: 
            case DIAMOND_HELMET: {
                if (this.player.isSneaking()) break;
                slot = 1;
                break;
            }
            case LEATHER_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case GOLD_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: {
                if (this.player.isSneaking()) break;
                slot = 2;
                break;
            }
            case LEATHER_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case GOLD_LEGGINGS: 
            case IRON_LEGGINGS: 
            case DIAMOND_LEGGINGS: {
                if (this.player.isSneaking()) break;
                slot = 3;
                break;
            }
            case LEATHER_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case GOLD_BOOTS: 
            case IRON_BOOTS: 
            case DIAMOND_BOOTS: {
                if (this.player.isSneaking()) break;
                slot = 4;
                break;
            }
            case AIR: {
                for (int i = 0; i < 5; ++i) {
                    if (trait.get(i) == null || trait.get(i).getType() == Material.AIR) continue;
                    this.player.getWorld().dropItemNaturally(this.npc.getBukkitEntity().getLocation(), trait.get(i));
                    trait.set(i, null);
                }
                Messaging.send((CommandSender)this.player, "<e>" + this.npc.getName() + " <a>had all of its items removed.");
            }
        }
        if (trait.get(slot) != null && trait.get(slot).getType() != Material.AIR) {
            this.player.getWorld().dropItemNaturally(this.npc.getBukkitEntity().getLocation(), trait.get(slot));
        }
        if ((set = hand) != null && set.getType() != Material.AIR) {
            if (hand.getAmount() > 1) {
                hand.setAmount(hand.getAmount() - 1);
            } else {
                hand = null;
            }
            this.player.setItemInHand(hand);
            set.setAmount(1);
        }
        trait.set(slot, set);
    }
}

