/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.SpawnLocation;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.ai.CitizensAI;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;

public abstract class CitizensNPC
extends AbstractNPC {
    protected final CitizensAI ai = new CitizensAI(this);
    protected final CitizensNPCManager manager;
    protected EntityLiving mcEntity;

    protected CitizensNPC(CitizensNPCManager manager, int id, String name) {
        super(id, name);
        this.manager = manager;
    }

    @Override
    public void chat(Player player, String message) {
        Messaging.sendWithNPC((CommandSender)player, Settings.Setting.CHAT_PREFIX.asString() + message, this);
    }

    @Override
    public void chat(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.chat(player, message);
        }
    }

    protected abstract EntityLiving createHandle(Location var1);

    @Override
    public boolean despawn() {
        if (!this.isSpawned()) {
            Messaging.debug("The NPC with the ID '" + this.getId() + "' is already despawned.");
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDespawnEvent(this));
        this.manager.despawn(this, this.getTrait(Spawned.class).shouldSpawn());
        this.mcEntity = null;
        return true;
    }

    @Override
    public CitizensAI getAI() {
        return this.ai;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        return (LivingEntity)this.getHandle().getBukkitEntity();
    }

    public EntityLiving getHandle() {
        return this.mcEntity;
    }

    public org.bukkit.inventory.Inventory getInventory() {
        org.bukkit.inventory.Inventory inventory = Bukkit.getServer().createInventory((InventoryHolder)this, 36, StringHelper.parseColors(this.getFullName()));
        inventory.setContents(this.getTrait(Inventory.class).getContents());
        return inventory;
    }

    @Override
    public boolean isSpawned() {
        return this.getHandle() != null;
    }

    @Override
    public void remove() {
        this.manager.remove(this);
        if (this.isSpawned()) {
            this.despawn();
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public boolean spawn(Location loc) {
        if (this.isSpawned()) {
            Messaging.debug("The NPC with the ID '" + this.getId() + "' is already spawned.");
            return false;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, loc);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            return false;
        }
        this.mcEntity = this.createHandle(loc);
        this.mcEntity.world.addEntity((Entity)this.mcEntity);
        this.mcEntity.world.players.remove(this.mcEntity);
        this.getTrait(SpawnLocation.class).setLocation(loc);
        this.getTrait(Spawned.class).setSpawned(true);
        return true;
    }

    @Override
    public void update() {
        super.update();
        this.ai.update();
    }
}

