/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.exception.TraitException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitManager;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.SpawnLocation;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;

public class CitizensTraitManager
implements TraitManager {
    private final Map<String, Class<? extends Trait>> registered = new HashMap<String, Class<? extends Trait>>();

    public CitizensTraitManager() {
        this.registerTrait(new TraitFactory(Equipment.class).withName("equipment"));
        this.registerTrait(new TraitFactory(Inventory.class).withName("inventory"));
        this.registerTrait(new TraitFactory(LookClose.class).withName("look-close"));
        this.registerTrait(new TraitFactory(MobType.class).withName("type"));
        this.registerTrait(new TraitFactory(Owner.class).withName("owner"));
        this.registerTrait(new TraitFactory(Spawned.class).withName("spawned"));
        this.registerTrait(new TraitFactory(SpawnLocation.class).withName("location"));
        this.registerTrait(new TraitFactory(Text.class).withName("text"));
        this.registerTrait(new TraitFactory(Waypoints.class).withName("waypoints"));
    }

    @Override
    public <T extends Trait> T getTrait(String name, NPC npc) {
        if (!this.registered.containsKey(name)) {
            return null;
        }
        Trait t = this.getTrait(this.registered.get(name), npc);
        try {
            if (t.getName() == null) {
                t.setName(name);
            }
            return (T)t;
        }
        catch (TraitException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        return this.getTrait(clazz, null);
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz, NPC npc) {
        for (String name : this.registered.keySet()) {
            if (!this.registered.get(name).equals(clazz)) continue;
            Trait t = this.create(this.registered.get(name), npc);
            try {
                if (t.getName() == null) {
                    t.setName(name);
                }
                return (T)t;
            }
            catch (TraitException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public <T extends Trait> T getTrait(String name) {
        if (!this.registered.containsKey(name)) {
            return null;
        }
        return (T)this.create(this.registered.get(name), null);
    }

    @Override
    public void registerTrait(TraitFactory factory) {
        this.registered.put(factory.getName(), factory.getTraitClass());
    }

    private <T extends Trait> T create(Class<T> trait, NPC npc) {
        Constructor<T> constructor;
        try {
            constructor = trait.getConstructor(NPC.class);
        }
        catch (Exception ex) {
            constructor = null;
        }
        try {
            if (npc == null) {
                return (T)((Trait)trait.newInstance());
            }
            return (T)(constructor != null ? (Trait)constructor.newInstance(npc) : (Trait)trait.newInstance());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

