/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.ai.AI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.NavigationCallback;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MoveStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.npc.ai.TargetStrategy;
import net.citizensnpcs.util.Messaging;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;

public class CitizensAI
implements AI {
    private Runnable ai;
    private final List<WeakReference<NavigationCallback>> callbacks = Lists.newArrayList();
    private PathStrategy executing;
    private final List<GoalEntry> executingGoals = Lists.newArrayList();
    private final List<GoalEntry> goals = Lists.newArrayList();
    private final CitizensNPC npc;
    private boolean paused;

    public CitizensAI(CitizensNPC npc) {
        this.npc = npc;
    }

    @Override
    public void addGoal(int priority, Goal goal) {
        if (this.goals.contains(goal)) {
            return;
        }
        this.goals.add(new GoalEntry(priority, goal));
        Collections.sort(this.goals);
    }

    @Override
    public boolean hasDestination() {
        return this.executing != null;
    }

    private boolean isGoalAllowable(GoalEntry test) {
        for (GoalEntry item : this.goals) {
            if (item == test || test.priority < item.priority || !this.executingGoals.contains(item) || test.goal.isCompatibleWith(item.goal)) continue;
            return false;
        }
        return true;
    }

    public void pause() {
        this.paused = true;
    }

    @Override
    public void registerNavigationCallback(NavigationCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(new WeakReference<NavigationCallback>(callback));
            callback.onAttach(this);
        }
    }

    public void resume() {
        this.paused = false;
    }

    @Override
    public void setAI(Runnable ai) {
        this.ai = ai;
    }

    @Override
    public void setDestination(Location destination) {
        NavigationCallback next;
        Iterator<WeakReference<NavigationCallback>> itr;
        if (this.executing != null) {
            itr = this.callbacks.iterator();
            while (itr.hasNext()) {
                next = (NavigationCallback)itr.next().get();
                if (next != null && !next.onCancel(this, NavigationCallback.PathCancelReason.PLUGIN)) continue;
                itr.remove();
            }
        }
        this.executing = new MoveStrategy(this.npc, destination);
        itr = this.callbacks.iterator();
        while (itr.hasNext()) {
            next = (NavigationCallback)itr.next().get();
            if (next != null && !next.onBegin(this)) continue;
            itr.remove();
        }
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        NavigationCallback next;
        Iterator<WeakReference<NavigationCallback>> itr;
        if (this.executing != null) {
            itr = this.callbacks.iterator();
            while (itr.hasNext()) {
                next = (NavigationCallback)itr.next().get();
                if (next != null && !next.onCancel(this, NavigationCallback.PathCancelReason.PLUGIN)) continue;
                itr.remove();
            }
        }
        this.executing = new TargetStrategy(this.npc, target, aggressive);
        itr = this.callbacks.iterator();
        while (itr.hasNext()) {
            next = (NavigationCallback)itr.next().get();
            if (next != null && !next.onBegin(this)) continue;
            itr.remove();
        }
    }

    public void update() {
        if (this.paused) {
            return;
        }
        if (this.executing != null && this.executing.update()) {
            Iterator<WeakReference<NavigationCallback>> itr = this.callbacks.iterator();
            while (itr.hasNext()) {
                NavigationCallback next = (NavigationCallback)itr.next().get();
                if (next != null && !next.onCompletion(this)) continue;
                itr.remove();
            }
            this.executing = null;
        }
        if (this.ai != null) {
            try {
                this.ai.run();
            }
            catch (Throwable ex) {
                Messaging.log("Unexpected error while running ai " + this.ai);
                ex.printStackTrace();
            }
        }
        for (GoalEntry entry : this.goals) {
            boolean executing = this.executingGoals.contains(entry);
            if (executing) {
                if (entry.goal.continueExecuting() && this.isGoalAllowable(entry)) continue;
                entry.goal.reset();
                this.executingGoals.remove(entry);
                continue;
            }
            if (!entry.goal.continueExecuting() || !this.isGoalAllowable(entry)) continue;
            entry.goal.start();
            this.executingGoals.add(entry);
        }
        for (GoalEntry entry : this.executingGoals) {
            entry.goal.update();
        }
    }

    private class GoalEntry
    implements Comparable<GoalEntry> {
        final Goal goal;
        final int priority;

        GoalEntry(int priority, Goal goal) {
            this.priority = priority;
            this.goal = goal;
        }

        @Override
        public int compareTo(GoalEntry o) {
            return o.priority > this.priority ? 1 : (o.priority < this.priority ? -1 : 0);
        }
    }
}

