/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import java.lang.reflect.Field;
import java.util.Random;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.MathHelper;
import net.minecraft.server.PathEntity;
import net.minecraft.server.Vec3D;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class MoveStrategy
implements PathStrategy {
    private Float cachedSpeed;
    private final EntityLiving handle;
    private final PathEntity path;
    private final Random random = new Random();
    private static final double JUMP_VELOCITY = 0.49;
    private static Field SPEED_FIELD;

    public MoveStrategy(CitizensNPC handle, Location destination) {
        this.handle = handle.getHandle();
        this.path = this.handle.world.a((Entity)this.handle, destination.getBlockX(), destination.getBlockY(), destination.getBlockZ(), 16.0f, true, false, false, true);
    }

    MoveStrategy(EntityLiving handle, PathEntity path) {
        this.handle = handle;
        this.path = path;
    }

    private Vec3D getVector() {
        Vec3D vec3d = this.path.a((Entity)this.handle);
        double lengthSq = this.handle.width * 2.0f;
        lengthSq *= lengthSq;
        while (vec3d != null && vec3d.d(this.handle.locX, vec3d.b, this.handle.locZ) < lengthSq) {
            this.path.a();
            if (this.path.b()) {
                return null;
            }
            vec3d = this.path.a((Entity)this.handle);
        }
        return vec3d;
    }

    private float getYawDifference(double diffZ, double diffX) {
        float vectorYaw = (float)(Math.atan2(diffZ, diffX) * 180.0 / Math.PI) - 90.0f;
        float diffYaw = (vectorYaw - this.handle.yaw) % 360.0f;
        return Math.max(-30.0f, Math.min(30.0f, diffYaw));
    }

    private void jump() {
        if (this.handle.onGround) {
            this.handle.motY = 0.49;
        }
    }

    @Override
    public boolean update() {
        if (this.handle.dead || this.path == null) {
            return true;
        }
        Vec3D vector = this.getVector();
        if (vector == null) {
            return true;
        }
        int yHeight = MathHelper.floor((double)(this.handle.boundingBox.b + 0.5));
        boolean inWater = ((Player)this.handle.getBukkitEntity()).getRemainingAir() < 20;
        boolean onFire = this.handle.fireTicks > 0;
        double diffX = vector.a - this.handle.locX;
        double diffZ = vector.c - this.handle.locZ;
        float diffYaw = this.getYawDifference(diffZ, diffX);
        this.handle.yaw += diffYaw;
        if (vector.b - (double)yHeight > 0.0) {
            this.jump();
        }
        if (this.cachedSpeed == null) {
            try {
                this.cachedSpeed = Float.valueOf(SPEED_FIELD.getFloat(this.handle));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                this.cachedSpeed = Float.valueOf(0.7f);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                this.cachedSpeed = Float.valueOf(0.7f);
            }
        }
        this.handle.e(this.cachedSpeed.floatValue());
        this.handle.e();
        if (this.handle.positionChanged) {
            this.jump();
        }
        if (this.random.nextFloat() < 0.8f && (inWater || onFire)) {
            this.handle.motY += 0.04;
        }
        return false;
    }

    static {
        try {
            SPEED_FIELD = EntityLiving.class.getDeclaredField("bb");
            SPEED_FIELD.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

