/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Player;

public class CitizensHumanNPC
extends CitizensNPC {
    public CitizensHumanNPC(CitizensNPCManager manager, int id, String name) {
        super(manager, id, name);
    }

    @Override
    protected EntityLiving createHandle(Location loc) {
        WorldServer ws = ((CraftWorld)loc.getWorld()).getHandle();
        EntityHumanNPC handle = new EntityHumanNPC(ws.getServer().getServer(), (World)ws, StringHelper.parseColors(this.getFullName()), new ItemInWorldManager(ws));
        handle.removeFromPlayerMap(this.getFullName());
        handle.setPositionRotation(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        return handle;
    }

    public Player getBukkitEntity() {
        return this.getHandle().getBukkitEntity();
    }

    public EntityHumanNPC getHandle() {
        return (EntityHumanNPC)this.mcEntity;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        super.load(key);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        Location prev = this.getBukkitEntity().getLocation();
        this.despawn();
        this.spawn(prev);
    }

    @Override
    public void update() {
        super.update();
        if (this.mcEntity == null) {
            return;
        }
    }
}

