/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.Iterator;
import net.citizensnpcs.api.ai.AI;
import net.citizensnpcs.api.ai.NavigationCallback;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.util.Messaging;
import org.bukkit.Location;

public class GenericWaypointCallback
extends NavigationCallback {
    private Location dest;
    private AI ai;
    private boolean executing;
    private Iterator<Waypoint> itr;
    private final Iterable<Waypoint> provider;

    public GenericWaypointCallback(Iterable<Waypoint> provider) {
        this.provider = provider;
    }

    private void ensureItr() {
        if (this.itr == null || !this.itr.hasNext()) {
            this.itr = this.provider.iterator();
        }
    }

    @Override
    public void onAttach(AI ai) {
        this.ai = ai;
        boolean bl = this.executing = !ai.hasDestination();
        if (!this.executing) {
            return;
        }
        if (this.dest == null) {
            this.ensureItr();
            if (this.itr.hasNext()) {
                this.dest = this.itr.next().getLocation();
            }
        }
        if (this.dest != null) {
            ai.setDestination(this.dest);
        }
    }

    @Override
    public boolean onCancel(AI ai, NavigationCallback.PathCancelReason reason) {
        if (this.executing) {
            this.executing = false;
        } else {
            this.executing = true;
            this.ensureItr();
            if (this.dest != null) {
                ai.setDestination(this.dest);
            } else if (this.itr.hasNext()) {
                ai.setDestination(this.itr.next().getLocation());
            }
        }
        return false;
    }

    @Override
    public boolean onCompletion(AI ai) {
        if (this.executing) {
            this.dest = this.itr.hasNext() ? this.itr.next().getLocation() : null;
            Messaging.log("fetched next");
        } else {
            this.executing = true;
        }
        if (this.dest != null) {
            ai.setDestination(this.dest);
        }
        return false;
    }

    public void onProviderChanged() {
        this.itr = this.provider.iterator();
        Location location = this.dest = this.itr.hasNext() ? this.itr.next().getLocation() : null;
        if (this.dest != null) {
            this.ai.setDestination(this.dest);
        }
    }
}

