/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.ai.NavigationCallback;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.GenericWaypointCallback;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class LinearWaypointProvider
implements WaypointProvider,
Iterable<Waypoint> {
    private final GenericWaypointCallback callback = new GenericWaypointCallback(this);
    private final List<Waypoint> waypoints = Lists.newArrayList();

    @Override
    public Editor createEditor(final Player player) {
        return new Editor(){

            @Override
            public void begin() {
                player.sendMessage(ChatColor.AQUA + "Entered the linear waypoint editor!");
                Messaging.send((CommandSender)player, "<e>Left click<a> to add a waypoint, <e>right click<a> to remove.");
            }

            @Override
            public void end() {
                player.sendMessage(ChatColor.AQUA + "Exited the linear waypoint editor.");
                LinearWaypointProvider.this.callback.onProviderChanged();
            }

            @EventHandler
            public void onPlayerInteract(PlayerInteractEvent event) {
                if (!event.getPlayer().equals(player)) {
                    return;
                }
                if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                    Location at = event.getClickedBlock().getLocation();
                    LinearWaypointProvider.this.waypoints.add(new Waypoint(at));
                    Messaging.send((CommandSender)player, String.format("<e>Added<a> a waypoint at (<e>%d<a>, <e>%d<a>, <e>%d<a>).", at.getBlockX(), at.getBlockY(), at.getBlockZ()));
                } else if (LinearWaypointProvider.this.waypoints.size() > 0) {
                    LinearWaypointProvider.this.waypoints.remove(LinearWaypointProvider.this.waypoints.size() - 1);
                    Messaging.send((CommandSender)player, String.format("<e>Removed<a> a waypoint (<e>%d<a> remaining)", LinearWaypointProvider.this.waypoints.size()));
                }
            }
        };
    }

    @Override
    public NavigationCallback getCallback() {
        return this.callback;
    }

    @Override
    public Iterator<Waypoint> iterator() {
        return this.waypoints.iterator();
    }

    @Override
    public void load(DataKey key) {
        for (DataKey root : key.getRelative("waypoints").getIntegerSubKeys()) {
            root = root.getRelative("location");
            this.waypoints.add(new Waypoint(new Location(Bukkit.getWorld((String)root.getString("world")), root.getDouble("x"), root.getDouble("y"), root.getDouble("z"), (float)root.getDouble("yaw", 0.0), (float)root.getDouble("pitch", 0.0))));
        }
        this.callback.onProviderChanged();
    }

    @Override
    public void save(DataKey key) {
        key = key.getRelative("waypoints");
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Location location = this.waypoints.get(i).getLocation();
            key = key.getRelative(Integer.toString(i) + ".location");
            key.setString("world", location.getWorld().getName());
            key.setDouble("x", location.getX());
            key.setDouble("y", location.getY());
            key.setDouble("z", location.getZ());
            key.setDouble("yaw", location.getYaw());
            key.setDouble("pitch", location.getPitch());
        }
    }
}

