/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import org.bukkit.entity.Player;

public class Waypoints
extends Trait {
    private final NPC npc;
    private WaypointProvider provider = new LinearWaypointProvider();
    private String providerName;
    private static final Map<Class<? extends WaypointProvider>, String> providers = new HashMap<Class<? extends WaypointProvider>, String>();

    public Waypoints(NPC npc) {
        this.npc = npc;
        npc.getAI().registerNavigationCallback(this.provider.getCallback());
    }

    public Editor getEditor(Player player) {
        return this.provider.createEditor(player);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.providerName = key.getString("provider", "linear");
        for (Class<? extends WaypointProvider> clazz : providers.keySet()) {
            if (!providers.get(clazz).equals(this.providerName)) continue;
            this.provider = this.create(clazz);
            break;
        }
        if (this.provider == null) {
            return;
        }
        this.provider.load(key.getRelative(this.providerName));
        this.npc.getAI().registerNavigationCallback(this.provider.getCallback());
    }

    @Override
    public void save(DataKey key) {
        if (this.provider == null) {
            return;
        }
        this.provider.save(key.getRelative(this.providerName));
        key.setString("provider", this.providerName);
    }

    public void setWaypointProvider(Class<? extends WaypointProvider> clazz) {
        this.provider = this.create(clazz);
        if (this.provider != null) {
            this.providerName = providers.get(clazz);
        }
    }

    private WaypointProvider create(Class<? extends WaypointProvider> clazz) {
        WaypointProvider provider;
        if (!providers.containsKey(clazz)) {
            return null;
        }
        try {
            provider = clazz.newInstance();
        }
        catch (Exception ex) {
            provider = null;
        }
        return provider;
    }

    public static void registerWaypointProvider(Class<? extends WaypointProvider> clazz, String name) {
        providers.put(clazz, name);
    }

    static {
        providers.put(LinearWaypointProvider.class, "linear");
    }
}

