/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftParrot;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;

public class ParrotController
extends MobEntityController {
    public ParrotController() {
        super(EntityParrotNPC.class, EntityTypes.aP);
    }

    public Parrot getBukkitEntity() {
        return (Parrot)super.getBukkitEntity();
    }

    public static class EntityParrotNPC
    extends EntityParrot
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityParrotNPC(EntityTypes<? extends EntityParrot> types, World level) {
            this(types, level, null);
        }

        public EntityParrotNPC(EntityTypes<? extends EntityParrot> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                this.bC = new ControllerMoveFlying((EntityInsentient)this, 10, true);
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public void dH() {
            if (this.npc == null) {
                super.dH();
            }
        }

        public void a(WorldServer level) {
            if (this.npc == null) {
                super.a(level);
            } else {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                if (this.npc.useMinecraftAI()) {
                    super.a(level);
                }
                this.npc.update();
            }
        }

        public SoundEffect s() {
            return NMSImpl.getSoundEffect(this.npc, super.s(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new ParrotNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect j_() {
            return NMSImpl.getSoundEffect(this.npc, super.j_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fh() {
            return NMS.getJumpPower(this.npc, super.fh());
        }

        public int cE() {
            return NMS.getFallDistance(this.npc, super.cE());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction i_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.i_();
        }

        public boolean Q_() {
            return NMSImpl.isLeashed(this.npc, () -> super.Q_(), (EntityInsentient)this);
        }

        public boolean bG() {
            return this.npc == null ? super.bG() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
            if (this.npc == null || !this.npc.isProtected()) {
                return super.b(entityhuman, enumhand);
            }
            return EnumInteractionResult.d;
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean g(NBTTagCompound save) {
            return this.npc == null ? super.g(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class ParrotNPC
    extends CraftParrot
    implements ForwardingNPCHolder {
        public ParrotNPC(EntityParrotNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityParrot)entity);
        }
    }
}

