/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.editor;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.gui.InventoryMenu;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.editor.EndermanEquipperGUI;
import net.citizensnpcs.editor.Equipper;
import net.citizensnpcs.editor.GenericEquipperGUI;
import net.citizensnpcs.editor.HorseEquipper;
import net.citizensnpcs.editor.SheepEquipper;
import net.citizensnpcs.editor.SteerableEquipperGUI;
import net.citizensnpcs.editor.WolfEquipper;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class EquipmentEditor
extends Editor {
    private InventoryMenu menu;
    private final NPC npc;
    private final Player player;
    private static final Map<EntityType, Class<? extends InventoryMenuPage>> EQUIPPER_GUIS = Maps.newEnumMap(EntityType.class);
    private static final Map<EntityType, Equipper> EQUIPPERS = Maps.newEnumMap(EntityType.class);

    public EquipmentEditor(Player player, NPC npc) {
        this.player = player;
        this.npc = npc;
    }

    @Override
    public void begin() {
        if (EQUIPPER_GUIS.containsKey(this.npc.getEntity().getType()) || !EQUIPPERS.containsKey(this.npc.getEntity().getType())) {
            HashMap ctx = Maps.newHashMap();
            ctx.put("npc", this.npc);
            this.menu = InventoryMenu.createWithContext(EQUIPPER_GUIS.getOrDefault(this.npc.getEntity().getType(), GenericEquipperGUI.class), ctx);
            this.menu.present((HumanEntity)this.player);
            return;
        }
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.equipment.begin", new Object[0]);
    }

    @Override
    public void end() {
        if (this.menu != null) {
            this.menu.close();
            this.menu = null;
            return;
        }
        Messaging.sendTr((CommandSender)this.player, "citizens.editors.equipment.end", new Object[0]);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.menu != null && event.getWhoClicked().equals((Object)this.player)) {
            this.menu.onInventoryClick(event);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryDragEvent event) {
        if (this.menu != null && event.getWhoClicked().equals((Object)this.player)) {
            this.menu.onInventoryDrag(event);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (this.menu != null && event.getPlayer().equals((Object)this.player)) {
            this.menu.onInventoryClose(event);
            Editor.leave((Player)event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.RIGHT_CLICK_AIR && event.getPlayer().equals((Object)this.player)) {
            event.setUseItemInHand(Event.Result.DENY);
        }
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!this.npc.isSpawned() || this.menu != null || !event.getPlayer().equals((Object)this.player) || Util.isOffHand(event) || !this.npc.equals(CitizensAPI.getNPCRegistry().getNPC(event.getRightClicked()))) {
            return;
        }
        Equipper equipper = EQUIPPERS.get(this.npc.getEntity().getType());
        equipper.equip(event.getPlayer(), this.npc);
        event.setCancelled(true);
    }

    static {
        EQUIPPER_GUIS.put(EntityType.PIG, SteerableEquipperGUI.class);
        try {
            EQUIPPER_GUIS.put(EntityType.valueOf((String)"STRIDER"), SteerableEquipperGUI.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EQUIPPER_GUIS.put(EntityType.ENDERMAN, EndermanEquipperGUI.class);
        EQUIPPERS.put(EntityType.SHEEP, new SheepEquipper());
        EQUIPPERS.put(EntityType.HORSE, new HorseEquipper());
        EQUIPPERS.put(EntityType.WOLF, new WolfEquipper());
        for (EntityType type : Util.optionalEntitySet("ZOMBIE_HORSE", "LLAMA", "TRADER_LLAMA", "DONKEY", "MULE", "SKELETON_HORSE", "CAMEL")) {
            EQUIPPERS.put(type, new HorseEquipper());
        }
    }
}

