/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.entity.nonliving;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_20_R4.entity.MobEntityController;
import net.citizensnpcs.nms.v1_20_R4.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_20_R4.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEnderSignal;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Entity;

public class EyeOfEnderController
extends MobEntityController {
    public EyeOfEnderController() {
        super(EntityEnderSignalNPC.class);
    }

    public EnderSignal getBukkitEntity() {
        return (EnderSignal)super.getBukkitEntity();
    }

    public static class EntityEnderSignalNPC
    extends EntityEnderSignal
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderSignalNPC(EntityTypes<? extends EntityEnderSignal> types, World level) {
            this(types, level, null);
        }

        public EntityEnderSignalNPC(EntityTypes<? extends EntityEnderSignal> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderSignalNPC(this));
            }
            return super.getBukkitEntity();
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction k_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.k_();
        }

        public boolean bA() {
            return this.npc == null ? super.bA() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        protected AxisAlignedBB as() {
            return NMSBoundingBox.makeBB(this.npc, super.as());
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity teleportTo(WorldServer worldserver, Vec3D location) {
            if (this.npc == null) {
                return super.teleportTo(worldserver, location);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, worldserver, location);
        }

        public void l() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.l();
            }
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.ds().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.h(old);
            }
            return res;
        }
    }

    public static class EnderSignalNPC
    extends CraftEnderSignal
    implements ForwardingNPCHolder {
        public EnderSignalNPC(EntityEnderSignalNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderSignal)entity);
        }
    }
}

