/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint.triggers;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.trait.waypoint.triggers.TeleportTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerPrompt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.RegexPrompt;
import org.bukkit.entity.Player;

public class TeleportTriggerPrompt
extends RegexPrompt
implements WaypointTriggerPrompt {
    private static Pattern PATTERN = Pattern.compile("here|back|[\\p{L}]+?:[0-9]+?:[0-9]+?:[0-9]+?", 66);

    public TeleportTriggerPrompt() {
        super(PATTERN);
    }

    protected Prompt acceptValidatedInput(ConversationContext context, String input) {
        if ((input = input.trim()).equalsIgnoreCase("back")) {
            return (Prompt)context.getSessionData((Object)"previous");
        }
        if (input.equalsIgnoreCase("here")) {
            Player player = (Player)context.getForWhom();
            context.setSessionData((Object)"created-trigger", (Object)new TeleportTrigger(player.getLocation()));
            return (Prompt)context.getSessionData((Object)"return-to");
        }
        String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((char)':').omitEmptyStrings().split((CharSequence)input), String.class);
        String worldName = parts[0];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            Messaging.sendErrorTr((CommandSender)context.getForWhom(), "citizens.commands.errors.missing-world", new Object[0]);
            return this;
        }
        int x = Integer.parseInt(parts[1]);
        int y = Integer.parseInt(parts[2]);
        int z = Integer.parseInt(parts[3]);
        context.setSessionData((Object)"created-trigger", (Object)new Location(world, (double)x, (double)y, (double)z));
        return (Prompt)context.getSessionData((Object)"return-to");
    }

    @Override
    public WaypointTrigger createFromShortInput(ConversationContext context, String input) {
        return null;
    }

    public String getPromptText(ConversationContext context) {
        Messaging.sendTr((CommandSender)context.getForWhom(), "citizens.editors.waypoints.triggers.teleport.prompt", new Object[0]);
        return "";
    }
}

