/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.schedulers.SchedulerRunnable;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerUpdateTask
extends SchedulerRunnable {
    private final Queue<PlayerTick> players = new ConcurrentLinkedQueue<PlayerTick>();
    private final Set<UUID> uuids = ConcurrentHashMap.newKeySet();
    private static final Queue<Entity> PLAYERS_PENDING_ADD = new ConcurrentLinkedQueue<Entity>();
    private static final Queue<UUID> PLAYERS_PENDING_REMOVE = new ConcurrentLinkedQueue<UUID>();

    @Override
    public void cancel() {
        super.cancel();
        this.uuids.clear();
        this.players.clear();
        PLAYERS_PENDING_ADD.clear();
        PLAYERS_PENDING_REMOVE.clear();
    }

    @Override
    public void run() {
        if (PLAYERS_PENDING_REMOVE.size() > 0) {
            this.players.removeIf(pt -> PLAYERS_PENDING_REMOVE.contains(((PlayerTick)pt).entity.getUniqueId()));
            for (UUID uuid : PLAYERS_PENDING_REMOVE) {
                this.uuids.remove(uuid);
            }
            PLAYERS_PENDING_REMOVE.clear();
        }
        for (Entity entity : PLAYERS_PENDING_ADD) {
            NPC next = ((NPCHolder)entity).getNPC();
            if (this.uuids.contains(entity.getUniqueId())) {
                NPC old;
                PlayerTick rm = null;
                Iterator itr = this.players.iterator();
                while (itr.hasNext()) {
                    PlayerTick pt2 = (PlayerTick)itr.next();
                    if (!pt2.entity.getUniqueId().equals(entity.getUniqueId())) continue;
                    rm = pt2;
                    itr.remove();
                    this.uuids.remove(pt2.entity.getUniqueId());
                    break;
                }
                if ((old = ((NPCHolder)rm.entity).getNPC()) != next) {
                    Messaging.severe("Player registered twice with different NPC instances", rm.entity.getUniqueId());
                }
                if (rm.entity instanceof Player) {
                    NMS.removeFromWorld(rm.entity);
                    NMS.remove(rm.entity);
                } else {
                    rm.entity.remove();
                }
            }
            if (next.hasTrait(PacketNPC.class)) {
                this.players.add(new PlayerTick(entity, () -> ((AbstractNPC)next).update()));
            } else {
                this.players.add(new PlayerTick(entity, NMS.playerTicker((Player)entity)));
            }
            this.uuids.add(entity.getUniqueId());
        }
        PLAYERS_PENDING_ADD.clear();
        for (PlayerTick player : this.players) {
            player.run();
        }
    }

    public static void deregister(Entity entity) {
        PLAYERS_PENDING_ADD.remove(entity);
        PLAYERS_PENDING_REMOVE.add(entity.getUniqueId());
    }

    public static void register(Entity entity) {
        PLAYERS_PENDING_REMOVE.remove(entity.getUniqueId());
        PLAYERS_PENDING_ADD.add(entity);
    }

    private static class PlayerTick
    implements Runnable {
        private final Entity entity;
        private final Runnable tick;

        public PlayerTick(Entity entity, Runnable tick) {
            this.entity = entity;
            this.tick = tick;
        }

        @Override
        public void run() {
            CitizensAPI.getScheduler().runEntityTask(this.entity, this.tick);
        }
    }
}

