/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.templates;

import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.RegisteredListener;

public class CommandEventAction
implements Consumer<NPC> {
    private final Set<UUID> uuids = Sets.newHashSet();
    private static MethodHandle GET_NPC = null;

    public CommandEventAction(Class<? extends NPCEvent> clazz, Consumer<NPC> commands) {
        try {
            HandlerList handlers = (HandlerList)clazz.getMethod("getHandlerList", new Class[0]).invoke(null, new Object[0]);
            handlers.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                try {
                    if (event.getClass() != clazz) {
                        return;
                    }
                    NPC npc = GET_NPC.invoke(event);
                    if (this.uuids.contains(npc.getUniqueId())) {
                        commands.accept(npc);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }, EventPriority.NORMAL, CitizensAPI.getPlugin(), true));
        }
        catch (Throwable ex) {
            Messaging.severe("Error registering template event listener");
            ex.printStackTrace();
        }
    }

    @Override
    public void accept(NPC npc) {
        this.uuids.add(npc.getUniqueId());
    }

    static {
        try {
            GET_NPC = MethodHandles.publicLookup().findVirtual(NPCEvent.class, "getNPC", MethodType.methodType(NPC.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

