/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.util.BoundingBox;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public abstract class CachingChunkBlockSource<T>
extends BlockSource {
    private final Map<ChunkCoord, ChunkCache> chunkCache = new HashMap<ChunkCoord, ChunkCache>();
    private final Object[][] chunks;
    private final int chunkX;
    private final int chunkZ;
    protected final World world;
    private static boolean SUPPORT_BOUNDING_BOX = true;
    private static boolean SUPPORT_GET_TYPE = true;

    protected CachingChunkBlockSource(Location location, float radius) {
        this(location.getWorld(), location.getBlockX(), location.getBlockZ(), radius);
    }

    protected CachingChunkBlockSource(World world, int x, int z, float radius) {
        this(world, (int)((float)x - radius), (int)((float)z - radius), (int)((float)x + radius), (int)((float)z + radius));
    }

    protected CachingChunkBlockSource(World world, int minX, int minZ, int maxX, int maxZ) {
        this.world = world;
        this.chunkX = minX >> 4;
        this.chunkZ = minZ >> 4;
        int maxChunkX = maxX >> 4;
        int maxChunkZ = maxZ >> 4;
        this.chunks = new Object[maxChunkX - this.chunkX + 1][maxChunkZ - this.chunkZ + 1];
        for (int x = this.chunkX; x < maxChunkX; ++x) {
            for (int z = this.chunkZ; z < maxChunkZ; ++z) {
                this.chunks[x - this.chunkX][z - this.chunkZ] = this.getChunkObject(x, z);
            }
        }
    }

    protected abstract BlockData getBlockData(T var1, int var2, int var3, int var4);

    @Override
    public BlockData getBlockDataAt(int x, int y, int z) {
        if (!this.isYWithinBounds(y)) {
            return null;
        }
        T chunk = this.getSpecific(x, z);
        if (chunk != null) {
            return this.getBlockData(chunk, x, y, z);
        }
        return this.world.getBlockData(x, y, z);
    }

    protected abstract T getChunkObject(int var1, int var2);

    @Override
    public BoundingBox getCollisionBox(int x, int y, int z) {
        if (!this.isYWithinBounds(y)) {
            return BoundingBox.EMPTY;
        }
        T chunk = this.getSpecific(x, z);
        if (chunk != null) {
            return this.getCollisionBox(chunk, x & 0xF, y, z & 0xF);
        }
        if (!SUPPORT_BOUNDING_BOX) {
            return null;
        }
        return BoundingBox.convert(this.world.getBlockAt(x, y, z).getBoundingBox());
    }

    protected abstract BoundingBox getCollisionBox(T var1, int var2, int var3, int var4);

    protected abstract int getLightLevel(T var1, int var2, int var3, int var4);

    @Override
    public Material getMaterialAt(int x, int y, int z) {
        if (!this.isYWithinBounds(y)) {
            return Material.AIR;
        }
        T chunk = this.getSpecific(x, z);
        if (chunk != null) {
            return this.getType(chunk, x, y, z);
        }
        return SUPPORT_GET_TYPE ? this.world.getType(x, y, z) : this.world.getBlockAt(x, y, z).getType();
    }

    private T getSpecific(int x, int z) {
        ChunkCoord key;
        ChunkCache prev;
        int xx = (x >> 4) - this.chunkX;
        int zz = (z >> 4) - this.chunkZ;
        if (xx >= 0 && xx < this.chunks.length) {
            Object[] inner = this.chunks[xx];
            if (zz >= 0 && zz < inner.length) {
                return (T)inner[zz];
            }
        }
        if ((prev = this.chunkCache.get(key = new ChunkCoord(x >> 4, z >> 4))) == null) {
            prev = new ChunkCache();
            this.chunkCache.put(key, prev);
        } else {
            if (prev.obj != null) {
                return prev.obj;
            }
            if (++prev.hitCount >= 2) {
                prev.obj = this.getChunkObject(x >> 4, z >> 4);
                return prev.obj;
            }
        }
        return null;
    }

    protected abstract Material getType(T var1, int var2, int var3, int var4);

    @Override
    public boolean isYWithinBounds(int y) {
        return SpigotUtil.checkYSafe(y, this.world);
    }

    static {
        try {
            Class.forName("org.bukkit.RegionAccessor").getMethod("getType", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            SUPPORT_GET_TYPE = false;
        }
        try {
            Block.class.getMethod("getBoundingBox", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            SUPPORT_BOUNDING_BOX = false;
        }
    }

    private static class ChunkCoord {
        int x;
        int z;

        public ChunkCoord(int xx, int zz) {
            this.x = xx;
            this.z = zz;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            ChunkCoord other = (ChunkCoord)obj;
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            return 31 * (31 * this.x) + this.z;
        }
    }

    private class ChunkCache {
        int hitCount;
        T obj;

        private ChunkCache() {
        }
    }
}

