/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitEventHandler;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

@TraitName(value="controllable")
public class Controllable
extends Trait {
    private MovementController controller;
    @Persist
    private BuiltInControls controls;
    @Persist
    private boolean enabled = true;
    @Persist(value="owner_required")
    private boolean ownerRequired;
    private static boolean SUPPORTS_PLAYER_INPUT_EVENT = true;

    public Controllable() {
        super("controllable");
    }

    private Player getFirstPlayer() {
        return NMS.getPassengers(this.npc.getEntity()).stream().filter(e -> e instanceof Player).findFirst().orElse(null);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean mount(Player toMount) {
        List<Entity> passengers = NMS.getPassengers(this.npc.getEntity());
        boolean alreadyMounted = false;
        for (Entity passenger : passengers) {
            if (passenger == null || passenger != toMount) continue;
            alreadyMounted = true;
            break;
        }
        if (alreadyMounted) {
            return false;
        }
        NMS.mount(this.npc.getEntity(), (Entity)toMount);
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    private void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.npc.isSpawned() || !this.enabled) {
            return;
        }
        Action performed = event.getAction();
        if (!NMS.getPassengers(this.npc.getEntity()).contains(event.getPlayer())) {
            return;
        }
        switch (performed) {
            case RIGHT_CLICK_BLOCK: {
                if (event.isCancelled()) {
                    return;
                }
            }
            case RIGHT_CLICK_AIR: {
                this.controller.rightClick(event);
                break;
            }
            case LEFT_CLICK_BLOCK: {
                if (event.isCancelled()) {
                    return;
                }
            }
            case LEFT_CLICK_AIR: {
                this.controller.leftClick(event);
                break;
            }
        }
    }

    @TraitEventHandler(value=@EventHandler)
    private void onRightClick(NPCRightClickEvent event) {
        if (!this.enabled || !this.npc.isSpawned()) {
            return;
        }
        if (!event.getClicker().hasPermission("citizens.npc.controllable") || !event.getClicker().hasPermission("citizens.npc.controllable." + this.npc.getEntity().getType().name().toLowerCase(Locale.ROOT)) || this.ownerRequired && !this.npc.getOrAddTrait(Owner.class).isOwnedBy((CommandSender)event.getClicker())) {
            return;
        }
        this.mount(event.getClicker());
        this.controller.rightClickEntity(event);
        event.setDelayedCancellation(true);
    }

    @Override
    public void onSpawn() {
        if (this.controls != null) {
            this.controller = (MovementController)this.controls.factory.apply(this.npc);
            return;
        }
        if (!(this.npc.getEntity() instanceof LivingEntity) && !(this.npc.getEntity() instanceof Vehicle)) {
            this.controller = new LookAirController(this.npc);
            return;
        }
        this.controller = Util.isAlwaysFlyable(this.npc.getEntity().getType()) ? new PlayerInputAirController(this.npc) : new GroundController(this.npc);
    }

    @Override
    public void run() {
        if (!this.enabled || !this.npc.isSpawned()) {
            return;
        }
        if (this.npc.getNavigator().isNavigating()) {
            return;
        }
        Player player = this.getFirstPlayer();
        if (player == null) {
            return;
        }
        ControllableInput input = new ControllableInput();
        if (SUPPORTS_PLAYER_INPUT_EVENT) {
            double d = player.getCurrentInput().isForward() ? 1.0 : (input.forward = player.getCurrentInput().isBackward() ? -1.0 : 0.0);
            input.horizontal = player.getCurrentInput().isLeft() ? 1.0 : (player.getCurrentInput().isRight() ? -1.0 : 0.0);
            input.jump = player.getCurrentInput().isJump();
            input.sneak = player.getCurrentInput().isSneak();
            input.sprint = player.getCurrentInput().isSprint();
        } else {
            input.forward = NMS.getForwardBackwardMovement((Entity)player);
            input.horizontal = NMS.getXZMovement((Entity)player);
            input.jump = NMS.shouldJump((Entity)player);
            input.sneak = NMS.isSneaking((Entity)player);
            input.sprint = player.isSprinting();
        }
        this.controller.run(player, input);
    }

    public void setControls(BuiltInControls controls) {
        this.controls = controls;
    }

    public boolean setEnabled(boolean enabled) {
        this.enabled = enabled;
        return enabled;
    }

    public void setOwnerRequired(boolean ownerRequired) {
        this.ownerRequired = ownerRequired;
    }

    public boolean toggle() {
        Player player;
        boolean bl = this.enabled = !this.enabled;
        if (!this.enabled && (player = this.getFirstPlayer()) != null) {
            player.leaveVehicle();
        }
        return this.enabled;
    }

    private static void setMountedYaw(Entity entity) {
        if (entity instanceof EnderDragon || !Settings.Setting.USE_BOAT_CONTROLS.asBoolean()) {
            return;
        }
        Location loc = entity.getLocation();
        Vector vel = entity.getVelocity();
        if (vel.lengthSquared() == 0.0) {
            return;
        }
        double tX = loc.getX() + vel.getX();
        double tZ = loc.getZ() + vel.getZ();
        if (loc.getZ() > tZ) {
            loc.setYaw((float)(-Math.toDegrees(Math.atan((loc.getX() - tX) / (loc.getZ() - tZ)))) + 180.0f);
        } else if (loc.getZ() < tZ) {
            loc.setYaw((float)(-Math.toDegrees(Math.atan((loc.getX() - tX) / (loc.getZ() - tZ)))));
        }
        NMS.look(entity, loc.getYaw(), loc.getPitch());
    }

    private static double updateSpeed(Entity handle, double yaw, ControllableInput input, double speed, float speedMod, double maxSpeed) {
        yaw = Math.toRadians(yaw);
        Vector vel = handle.getVelocity();
        double oldSpeed = Math.sqrt(vel.getX() * vel.getX() + vel.getZ() * vel.getZ());
        if (input.forward > 0.0) {
            vel = vel.setX(-Math.sin(yaw) * speed * (double)speedMod).setZ(Math.cos(yaw) * speed * (double)speedMod);
        }
        vel.add(new Vector(Math.sin(yaw + 1.5707963267948966), 0.0, -Math.cos(yaw + 1.5707963267948966)).multiply((double)speedMod * Settings.Setting.CONTROLLABLE_GROUND_DIRECTION_MODIFIER.asDouble() * input.horizontal));
        vel.multiply(0.98);
        double newSpeed = Math.sqrt(vel.getX() * vel.getX() + vel.getZ() * vel.getZ());
        if (newSpeed > maxSpeed) {
            vel = vel.multiply(new Vector(maxSpeed / newSpeed, 1.0, maxSpeed / newSpeed));
            newSpeed = maxSpeed;
        }
        handle.setVelocity(vel);
        if (newSpeed > oldSpeed && speed < maxSpeed) {
            return (float)Math.min(maxSpeed, speed + (maxSpeed - speed) / 50.0);
        }
        return (float)Math.max(0.0, speed - speed / 50.0);
    }

    static {
        try {
            Class.forName("org.bukkit.event.player.PlayerInputEvent");
        }
        catch (ClassNotFoundException e) {
            SUPPORTS_PLAYER_INPUT_EVENT = false;
        }
    }

    private static class ControllableInput {
        double forward;
        double horizontal;
        boolean jump;
        boolean sneak;
        boolean sprint;

        private ControllableInput() {
        }
    }

    public static interface MovementController {
        public void leftClick(PlayerInteractEvent var1);

        public void rightClick(PlayerInteractEvent var1);

        public void rightClickEntity(NPCRightClickEvent var1);

        public void run(Player var1, ControllableInput var2);
    }

    public static enum BuiltInControls {
        AIR(PlayerInputAirController::new),
        GROUND(GroundController::new),
        GROUND_JUMPLESS(JumplessGroundController::new),
        LOOK_AIR(LookAirController::new);

        private final Function<NPC, MovementController> factory;

        private BuiltInControls(Function<NPC, MovementController> factory) {
            this.factory = factory;
        }
    }

    public static class LookAirController
    implements MovementController {
        private final NPC npc;
        private boolean paused = false;

        public LookAirController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
        }

        @Override
        public void run(Player rider, ControllableInput input) {
            if (this.paused) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.001));
                return;
            }
            Vector dir = rider.getEyeLocation().getDirection();
            dir.multiply(this.npc.getNavigator().getDefaultParameters().speedModifier());
            this.npc.getEntity().setVelocity(dir);
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }

    public static class PlayerInputAirController
    implements MovementController {
        private final NPC npc;
        private boolean paused = false;
        private double speed;

        public PlayerInputAirController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
            this.paused = !this.paused;
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
            this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(-0.25f));
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
        }

        @Override
        public void run(Player rider, ControllableInput input) {
            if (this.paused) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.001f));
                return;
            }
            this.speed = Controllable.updateSpeed(this.npc.getEntity(), NMS.getYaw((Entity)rider), input, this.speed, 1.0f, Settings.Setting.MAX_CONTROLLABLE_FLIGHT_SPEED.asDouble());
            if (input.jump) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.25f));
            }
            this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().multiply(new Vector(1.0, 0.98, 1.0)));
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }

    public static class GroundController
    implements MovementController {
        private int jumpTicks = 0;
        private final NPC npc;
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;
        private static final float JUMP_VELOCITY = 0.5f;

        public GroundController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
        }

        @Override
        public void run(Player rider, ControllableInput input) {
            boolean onGround = NMS.isOnGround(this.npc.getEntity());
            float speedMod = this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 0.5f : 0.5f);
            if (!Util.isHorse(this.npc.getEntity().getType())) {
                this.speed = Controllable.updateSpeed(this.npc.getEntity(), NMS.getYaw((Entity)rider), input, this.speed, speedMod, Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble());
            }
            if (onGround && this.jumpTicks <= 0 && input.jump) {
                this.npc.getEntity().setVelocity(this.npc.getEntity().getVelocity().setY(0.5f));
                this.jumpTicks = 10;
            }
            --this.jumpTicks;
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }

    public static class JumplessGroundController
    implements MovementController {
        private final NPC npc;
        private double speed = 0.07;
        private static final float AIR_SPEED = 0.5f;
        private static final float GROUND_SPEED = 0.5f;

        public JumplessGroundController(NPC npc) {
            this.npc = npc;
        }

        @Override
        public void leftClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClick(PlayerInteractEvent event) {
        }

        @Override
        public void rightClickEntity(NPCRightClickEvent event) {
        }

        @Override
        public void run(Player rider, ControllableInput input) {
            boolean onGround = NMS.isOnGround(this.npc.getEntity());
            float speedMod = this.npc.getNavigator().getDefaultParameters().modifiedSpeed(onGround ? 0.5f : 0.5f);
            if (!Util.isHorse(this.npc.getEntity().getType())) {
                this.speed = Controllable.updateSpeed(this.npc.getEntity(), NMS.getYaw((Entity)rider), input, this.speed, speedMod, Settings.Setting.MAX_CONTROLLABLE_GROUND_SPEED.asDouble());
            }
            Controllable.setMountedYaw(this.npc.getEntity());
        }
    }
}

