/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree;

import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.Behavior;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;

public abstract class Precondition
implements Behavior {
    protected final Supplier<Boolean> condition;

    protected Precondition(Supplier<Boolean> condition) {
        this.condition = condition;
    }

    public static Precondition runPrecondition(Supplier<Boolean> condition) {
        return new RunPrecondition(condition);
    }

    public static Precondition wrappingPrecondition(Behavior wrapping, Supplier<Boolean> condition) {
        return new WrappingPrecondition(wrapping, condition);
    }

    private static class RunPrecondition
    extends Precondition {
        public RunPrecondition(Supplier<Boolean> condition) {
            super(condition);
        }

        @Override
        public void reset() {
        }

        @Override
        public BehaviorStatus run() {
            return (Boolean)this.condition.get() != false ? BehaviorStatus.SUCCESS : BehaviorStatus.FAILURE;
        }

        @Override
        public boolean shouldExecute() {
            return true;
        }
    }

    private static class WrappingPrecondition
    extends Precondition {
        private final Behavior wrapping;

        public WrappingPrecondition(Behavior wrapping, Supplier<Boolean> condition) {
            super(condition);
            this.wrapping = wrapping;
        }

        @Override
        public void reset() {
            this.wrapping.reset();
        }

        @Override
        public BehaviorStatus run() {
            return this.wrapping.run();
        }

        @Override
        public boolean shouldExecute() {
            return (Boolean)this.condition.get() != false ? this.wrapping.shouldExecute() : false;
        }
    }
}

