/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.SimpleGoalController;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.ai.speech.event.NPCSpeechEvent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.event.NPCCloneEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.event.NPCRemoveTraitEvent;
import net.citizensnpcs.api.event.NPCRenameEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.RemoveReason;
import net.citizensnpcs.api.npc.SimpleMetadataStore;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.trait.ArrayTraitLookup;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitLookup;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.ItemStorage;
import net.citizensnpcs.api.util.MemoryDataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Placeholders;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractNPC
implements NPC {
    private final List<String> clearSaveData = Lists.newArrayList();
    protected Object coloredNameComponentCache;
    protected String coloredNameStringCache;
    private final GoalController goalController = new SimpleGoalController();
    private final int id;
    private Supplier<ItemStack> itemProvider = () -> {
        Material id = this.data().has(NPC.Metadata.ITEM_ID) ? Material.getMaterial((String)((String)this.data().get(NPC.Metadata.ITEM_ID)), (boolean)false) : null;
        int data = this.data().get(NPC.Metadata.ITEM_DATA, this.data().get("falling-block-data", Integer.valueOf(0)));
        if (id == Material.AIR || id == null) {
            id = Material.STONE;
            Messaging.severe(this.getId(), "invalid Material: converted to stone");
        }
        return new ItemStack(id, this.data().get(NPC.Metadata.ITEM_AMOUNT, Integer.valueOf(1)).intValue(), (short)data);
    };
    private final MetadataStore metadata = new SimpleMetadataStore();
    private String name;
    private final NPCRegistry registry;
    private final List<Runnable> runnables = Lists.newArrayList();
    private final SpeechController speechController = context -> {
        context.setTalker(this.getEntity());
        NPCSpeechEvent event = new NPCSpeechEvent(context);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        CitizensAPI.talk(context);
    };
    protected final TraitLookup traits = new ArrayTraitLookup(CitizensAPI.getTraitFactory().getRegisteredTraits().size() + 32);
    private final UUID uuid;
    private static final String[] PRIORITY_TRAITS = new String[]{"location", "type"};

    protected AbstractNPC(UUID uuid, int id, String name, NPCRegistry registry) {
        this.uuid = uuid;
        this.id = id;
        this.registry = registry;
        this.setNameInternal(name);
        CitizensAPI.getTraitFactory().addDefaultTraits(this);
    }

    @Override
    public void addRunnable(Runnable runnable) {
        this.runnables.add(runnable);
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            Messaging.severe("Cannot register a null trait. Was it registered properly?");
            return;
        }
        Trait replaced = this.traits.get(trait.getTraitId());
        if (replaced != null) {
            Messaging.debug("NPC", this, "replacing trait", replaced, "with", trait);
            replaced.onRemove();
            this.runnables.remove(replaced);
        }
        trait.linkToNPC(this);
        if (CitizensAPI.getPlugin().isEnabled()) {
            Bukkit.getPluginManager().registerEvents((Listener)trait, CitizensAPI.getPlugin());
        }
        this.traits.add(trait.getTraitId(), trait);
        if (this.isSpawned()) {
            trait.onSpawn();
        }
        if (trait.isRunImplemented()) {
            this.runnables.add(trait);
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCAddTraitEvent((NPC)this, trait));
    }

    @Override
    public NPC clone() {
        return this.copy();
    }

    @Override
    public NPC copy() {
        NPC copy = this.registry.createNPC(this.getOrAddTrait(MobType.class).getType(), this.getRawName());
        MemoryDataKey key = new MemoryDataKey();
        this.save(key);
        copy.load(key);
        for (Trait trait : copy.getTraits()) {
            trait.onCopy();
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCCloneEvent((NPC)this, copy));
        return copy;
    }

    @Override
    public MetadataStore data() {
        return this.metadata;
    }

    @Override
    public void destroy() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        this.traits.forEach(trait -> {
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove(RemoveReason.DESTROYED);
        });
        this.traits.clear();
        this.goalController.clear();
        this.registry.deregister(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNPC other = (AbstractNPC)obj;
        return Objects.equals(this.uuid, other.uuid);
    }

    @Override
    public GoalController getDefaultGoalController() {
        return this.goalController;
    }

    @Override
    public SpeechController getDefaultSpeechController() {
        return this.speechController;
    }

    protected EntityType getEntityType() {
        return this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
    }

    @Override
    public String getFullName() {
        int nameLength = SpigotUtil.getMaxNameLength(this.getEntityType());
        String replaced = Placeholders.replaceName(this.coloredNameStringCache != null ? this.coloredNameStringCache : Messaging.parseComponents(this.name), null, this);
        if (Messaging.stripColor(replaced).length() > nameLength) {
            Messaging.severe("ID", this.id, "created with name length greater than " + nameLength + ", truncating", replaced, "to", replaced.substring(0, nameLength));
            replaced = replaced.substring(0, nameLength);
        }
        return replaced;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Supplier<ItemStack> getItemProvider() {
        return this.itemProvider;
    }

    @Override
    public UUID getMinecraftUniqueId() {
        UUID uuid;
        if (this.getEntityType() == EntityType.PLAYER && (uuid = this.getUniqueId()).version() == 4) {
            long msb = uuid.getMostSignificantBits();
            msb &= 0xFFFFFFFFFFFFBFFFL;
            return new UUID(msb |= 0x2000L, uuid.getLeastSignificantBits());
        }
        return this.getUniqueId();
    }

    @Override
    public String getName() {
        return Messaging.stripColor(this.coloredNameStringCache);
    }

    @Override
    public <T extends Trait> T getOrAddTrait(Class<T> clazz) {
        Trait trait = this.traits.get(CitizensAPI.getTraitFactory().getId(clazz));
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)((Trait)clazz.cast(trait));
    }

    @Override
    public NPCRegistry getOwningRegistry() {
        return this.registry;
    }

    @Override
    public String getRawName() {
        return this.name;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> trait) {
        return this.getOrAddTrait(trait);
    }

    protected Trait getTraitFor(Class<? extends Trait> clazz) {
        return CitizensAPI.getTraitFactory().getTrait(clazz);
    }

    @Override
    public <T extends Trait> T getTraitNullable(Class<T> clazz) {
        return (T)((Trait)clazz.cast(this.traits.get(CitizensAPI.getTraitFactory().getId(clazz))));
    }

    @Override
    public Iterable<Trait> getTraits() {
        return this.traits.list();
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    public int hashCode() {
        return 31 + this.uuid.hashCode();
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> clazz) {
        return this.traits.has(CitizensAPI.getTraitFactory().getId(clazz));
    }

    @Override
    public void load(DataKey root) {
        this.setNameInternal(root.getString("name"));
        if (root.keyExists("itemprovider")) {
            ItemStack item = ItemStorage.loadItemStack(root.getRelative("itemprovider"));
            this.setItemProvider(() -> item.clone());
        }
        this.metadata.loadFrom(root.getRelative("metadata"));
        String traitNames = root.getString("traitnames");
        if (traitNames.isEmpty()) {
            Messaging.severe("Corrupted savedata (empty trait names) for NPC", this);
            return;
        }
        HashSet loading = Sets.newHashSet((Iterable)Splitter.on((char)',').omitEmptyStrings().split((CharSequence)traitNames));
        DataKey traits = root.getRelative("traits");
        for (String key : PRIORITY_TRAITS) {
            DataKey pkey = traits.getRelative(key);
            if (!pkey.keyExists()) continue;
            this.loadTraitFromKey(pkey);
            loading.remove(key);
        }
        for (DataKey key : Iterables.transform((Iterable)loading, traits::getRelative)) {
            this.loadTraitFromKey(key);
        }
    }

    private void loadTraitFromKey(DataKey traitKey) {
        Trait trait;
        Class<? extends Trait> clazz = CitizensAPI.getTraitFactory().getTraitClass(traitKey.name());
        if (this.hasTrait(clazz)) {
            trait = this.getTraitNullable(clazz);
        } else {
            trait = CitizensAPI.getTraitFactory().getTrait(clazz);
            if (trait == null) {
                Messaging.severeTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
                return;
            }
            this.addTrait(trait);
        }
        try {
            PersistenceLoader.load(trait, traitKey);
            trait.load(traitKey);
        }
        catch (Throwable ex) {
            if (Messaging.isDebugging()) {
                ex.printStackTrace();
            }
            Messaging.logTr("citizens.notifications.trait-load-failed", traitKey.name(), this.getId());
        }
    }

    @Override
    public void removeTrait(Class<? extends Trait> clazz) {
        Trait trait = this.traits.remove(CitizensAPI.getTraitFactory().getId(clazz));
        if (trait != null) {
            Bukkit.getPluginManager().callEvent((Event)new NPCRemoveTraitEvent((NPC)this, trait));
            this.clearSaveData.add("traits." + trait.getName());
            if (trait.isRunImplemented()) {
                this.runnables.remove(trait);
            }
            HandlerList.unregisterAll((Listener)trait);
            trait.onRemove(RemoveReason.REMOVAL);
        }
    }

    @Override
    public boolean requiresNameHologram() {
        return this.name.length() > 16 && this.getEntityType() == EntityType.PLAYER || this.data().get(NPC.Metadata.ALWAYS_USE_NAME_HOLOGRAM, Boolean.valueOf(false)) != false || this.coloredNameStringCache != null && this.coloredNameStringCache.contains("\u00a7") || !Placeholders.replaceName(this.name, null, this).equals(this.name);
    }

    @Override
    public void save(DataKey root) {
        if (!this.metadata.get(NPC.Metadata.SHOULD_SAVE, Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.metadata.saveTo(root.getRelative("metadata"));
        root.setString("name", this.name);
        root.setString("uuid", this.uuid.toString());
        if (this.data().has(NPC.Metadata.ITEM_ID)) {
            ItemStack stack = this.itemProvider.get();
            ItemStorage.saveItem(root.getRelative("itemprovider"), stack);
        } else {
            root.removeKey("itemprovider");
        }
        Set traitNames = Splitter.on((char)',').omitEmptyStrings().splitToStream((CharSequence)root.getString("traitnames")).collect(Collectors.toSet());
        this.traits.forEach(trait -> {
            this.clearSaveData.remove("traits." + trait.getName());
            traitNames.add(trait.getName());
            DataKey traitKey = root.getRelative("traits." + trait.getName());
            try {
                trait.save(traitKey);
            }
            catch (Throwable t) {
                Messaging.severe("Saving trait", trait, "failed for NPC", this);
                t.printStackTrace();
                return;
            }
            try {
                PersistenceLoader.save(trait, traitKey);
            }
            catch (Throwable t) {
                Messaging.severe("PersistenceLoader failed saving trait", trait, "for NPC", this);
                t.printStackTrace();
                return;
            }
        });
        for (String clear : this.clearSaveData) {
            if (clear.startsWith("traits.")) {
                traitNames.remove(clear.replace("traits.", ""));
            }
            root.removeKey(clear);
        }
        root.setString("traitnames", Joiner.on((char)',').join(traitNames));
        this.clearSaveData.clear();
    }

    @Override
    public void setItemProvider(Supplier<ItemStack> provider) {
        this.itemProvider = provider;
        ItemStack stack = provider.get();
        if (stack != null) {
            this.data().set(NPC.Metadata.ITEM_ID, (Object)stack.getType().name());
            this.data().set(NPC.Metadata.ITEM_DATA, (Object)stack.getData().getData());
            this.data().set(NPC.Metadata.ITEM_AMOUNT, (Object)stack.getAmount());
        }
    }

    @Override
    public void setName(String name) {
        if (name.equals(this.name)) {
            return;
        }
        NPCRenameEvent event = new NPCRenameEvent(this, this.name, name);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.setNameInternal(event.getNewName());
        if (!this.isSpawned()) {
            return;
        }
        Entity bukkitEntity = this.getEntity();
        if (bukkitEntity.getType() == EntityType.PLAYER && !this.requiresNameHologram()) {
            Location old = bukkitEntity.getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
            this.spawn(old);
        }
    }

    protected void setNameInternal(String name) {
        this.name = name;
        this.coloredNameComponentCache = Messaging.minecraftComponentFromRawMessage(this.name);
        this.coloredNameStringCache = Messaging.parseComponents(this.name);
    }

    private void teleport(Entity entity, Location location, int delay, PlayerTeleportEvent.TeleportCause cause) {
        Entity passenger = entity.getPassenger();
        entity.eject();
        if (!location.getWorld().equals((Object)entity.getWorld())) {
            CitizensAPI.getScheduler().runEntityTaskLater(entity, () -> SpigotUtil.teleportAsync(entity, location, cause), delay++);
        } else {
            SpigotUtil.teleportAsync(entity, location, cause);
        }
        if (passenger == null) {
            return;
        }
        this.teleport(passenger, location, delay++, cause);
        Runnable task = () -> entity.setPassenger(passenger);
        if (!location.getWorld().equals((Object)entity.getWorld())) {
            CitizensAPI.getScheduler().runEntityTaskLater(entity, task, delay);
        } else {
            task.run();
        }
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (!this.isSpawned()) {
            return;
        }
        NPCTeleportEvent event = new NPCTeleportEvent((NPC)this, location);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        Entity entity = this.getEntity();
        while (entity.getVehicle() != null) {
            entity = entity.getVehicle();
        }
        location.getBlock().getChunk();
        this.teleport(entity, location, 5, cause);
    }

    public void update() {
        for (int i = 0; i < this.runnables.size(); ++i) {
            this.runnables.get(i).run();
        }
        if (this.isSpawned()) {
            this.goalController.run();
        }
    }
}

