/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.citizensnpcs.api.persistence.ComponentPersister;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.EulerAnglePersister;
import net.citizensnpcs.api.persistence.ItemStackPersister;
import net.citizensnpcs.api.persistence.LocationPersister;
import net.citizensnpcs.api.persistence.NamespacedKeyPersister;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persistable;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.persistence.PersisterRegistry;
import net.citizensnpcs.api.persistence.QuaternionfPersister;
import net.citizensnpcs.api.persistence.UUIDPersister;
import net.citizensnpcs.api.persistence.VectorPersister;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;
import org.joml.Quaternionfc;

public class PersistenceLoader {
    private static final Map<Class<?>, Constructor<?>> constructorCache = new WeakHashMap();
    private static final Map<Class<?>, PersistField[]> fieldCache = new WeakHashMap();
    private static final Map<Class<? extends Persister<?>>, Persister<?>> loadedDelegates = new WeakHashMap();
    private static final Exception loadException = new Exception(){
        private static final long serialVersionUID = -4245839150826112365L;

        public void fillInStackTrace(StackTraceElement[] elements) {
        }
    };
    private static final Map<Class<?>, Class<? extends Persister<?>>> persistRedirects = new WeakHashMap();
    private static final Map<Class<?>, PersisterRegistry<?>> registries = new WeakHashMap();
    private static boolean SUPPORTS_KEYED = false;

    public static <T> PersisterRegistry<T> createRegistry(Class<?> base) {
        PersisterRegistry registry = new PersisterRegistry();
        registries.put(base, registry);
        return registry;
    }

    private static String createRelativeKey(String key, int ext) {
        return PersistenceLoader.createRelativeKey(key, Integer.toString(ext));
    }

    private static String createRelativeKey(String parent, String ext) {
        if (ext.isEmpty()) {
            return parent;
        }
        if (ext.charAt(0) == '.') {
            return parent.isEmpty() ? ext.substring(1) : parent + ext;
        }
        return parent.isEmpty() ? ext : parent + '.' + ext;
    }

    private static void deserialise(PersistField field, Object instance, Object oldValue, DataKey root) throws Exception {
        Object value;
        Class type = field.getType();
        Class<?> collectionType = field.getCollectionType();
        if (!Collection.class.isAssignableFrom(collectionType) && !Map.class.isAssignableFrom(collectionType)) {
            throw loadException;
        }
        if (Collection.class.isAssignableFrom(type) && !root.keyExists(field.key)) {
            return;
        }
        if (List.class.isAssignableFrom(type)) {
            List list = !List.class.isAssignableFrom(collectionType) ? Lists.newArrayList() : collectionType.newInstance();
            Object raw = root.getRaw(field.key);
            if (raw instanceof List && collectionType.isAssignableFrom(raw.getClass())) {
                list = (List)raw;
            } else {
                PersistenceLoader.deserialiseCollection(list, root, field);
            }
            value = list;
        } else if (Set.class.isAssignableFrom(type)) {
            Set<Object> set = Set.class.isAssignableFrom(collectionType) ? (EnumSet<Object>)collectionType.newInstance() : (field.getType().isEnum() ? EnumSet.noneOf(field.getType()) : (Set)(oldValue != null && Set.class.isAssignableFrom(oldValue.getClass()) ? oldValue.getClass().newInstance() : Sets.newHashSet()));
            PersistenceLoader.deserialiseCollection(set, root, field);
            value = set;
        } else if (Map.class.isAssignableFrom(type)) {
            Map map;
            if (Map.class.isAssignableFrom(collectionType)) {
                map = (Map)collectionType.newInstance();
            } else {
                boolean hasConcreteType = oldValue != null && Map.class.isAssignableFrom(oldValue.getClass()) && !oldValue.getClass().isInterface();
                map = (Map)(hasConcreteType ? oldValue : Maps.newHashMap());
            }
            PersistenceLoader.deserialiseMap(map, root, field);
            value = map;
        } else if (float[].class.isAssignableFrom(type)) {
            ArrayList floats = Lists.newArrayList();
            for (DataKey sub : root.getRelative(field.key).getIntegerSubKeys()) {
                floats.add(Float.valueOf((float)sub.getDouble("")));
            }
            value = new float[floats.size()];
            for (int i = 0; i < floats.size(); ++i) {
                ((float[])value)[i] = ((Float)floats.get(i)).floatValue();
            }
        } else if (double[].class.isAssignableFrom(type)) {
            ArrayList doubles = Lists.newArrayList();
            for (DataKey sub : root.getRelative(field.key).getIntegerSubKeys()) {
                doubles.add(sub.getDouble(""));
            }
            value = new double[doubles.size()];
            for (int i = 0; i < doubles.size(); ++i) {
                ((double[])value)[i] = (Double)doubles.get(i);
            }
        } else if (int[].class.isAssignableFrom(type)) {
            ArrayList ints = Lists.newArrayList();
            for (DataKey sub : root.getRelative(field.key).getIntegerSubKeys()) {
                ints.add(sub.getInt(""));
            }
            value = new int[ints.size()];
            for (int i = 0; i < ints.size(); ++i) {
                ((int[])value)[i] = (Integer)ints.get(i);
            }
        } else {
            value = field.key.equals("$key") ? (Integer.TYPE.isAssignableFrom(type) ? Integer.valueOf(Integer.parseInt(root.name())) : root.name()) : PersistenceLoader.deserialiseValue(field, root.getRelative(field.key));
        }
        if (value == null && field.isRequired()) {
            throw loadException;
        }
        if (type.isPrimitive() || Primitives.isWrapperType(type)) {
            Class<?> clazz;
            if (value == null) {
                return;
            }
            if (!Primitives.isWrapperType(type)) {
                type = Primitives.wrap(type);
            }
            if ((clazz = value.getClass()) == Integer.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            if (clazz == Float.class && type != Double.class && type != Float.class) {
                return;
            }
            if (clazz == Double.class && type != Double.class) {
                if (type == Float.class) {
                    value = Float.valueOf(((Double)value).floatValue());
                } else {
                    return;
                }
            }
            if (clazz == Byte.class && type != Short.class && type != Byte.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            if (clazz == Short.class && type != Short.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
            if (clazz == Character.class && type != Character.class && type != Short.class && type != Integer.class && type != Double.class && type != Long.class && type != Float.class) {
                return;
            }
        } else if (value != null && !type.isAssignableFrom(value.getClass())) {
            if (root.getRelative(field.key).getSubKeys().iterator().hasNext() && field.field.getType() == String.class && field.delegate == null) {
                field.set(instance, root.getRelative(field.key).name());
            }
            return;
        }
        if (value == null && field.defaultValue != null) {
            field.set(instance, field.defaultValue);
            return;
        }
        field.set(instance, value);
    }

    private static void deserialiseCollection(Collection<Object> collection, DataKey root, PersistField field) {
        for (DataKey subKey : root.getRelative(field.key).getSubKeys()) {
            Object loaded = PersistenceLoader.deserialiseCollectionValue(field, subKey, field.persistAnnotation.valueType());
            if (loaded == null) continue;
            collection.add(loaded);
        }
    }

    private static Object deserialiseCollectionValue(PersistField field, DataKey subKey, Class<?> type) {
        Object deserialised = PersistenceLoader.deserialiseValue(field, subKey);
        if (deserialised == null || type == Object.class) {
            return deserialised;
        }
        Class clazz = deserialised.getClass();
        if (type.isPrimitive() || Primitives.isWrapperType(type)) {
            if (!Primitives.isWrapperType(clazz)) {
                clazz = Primitives.wrap(clazz);
            }
            if (type != clazz) {
                if (type == Long.class) {
                    return ((Number)deserialised).longValue();
                }
                if (type == Byte.class) {
                    return ((Number)deserialised).byteValue();
                }
                if (type == Short.class) {
                    return ((Number)deserialised).shortValue();
                }
                if (type == Float.class) {
                    return Float.valueOf(((Number)deserialised).floatValue());
                }
                if (type == Double.class) {
                    return ((Number)deserialised).doubleValue();
                }
                if (type == Integer.class) {
                    return ((Number)deserialised).intValue();
                }
            }
        }
        return deserialised;
    }

    private static void deserialiseMap(Map<Object, Object> map, DataKey root, PersistField field) {
        for (DataKey subKey : root.getRelative(field.key).getSubKeys()) {
            Object loaded = PersistenceLoader.deserialiseCollectionValue(field, subKey, field.persistAnnotation.valueType());
            if (loaded == null) continue;
            Object key = subKey.name();
            Class<?> type = field.persistAnnotation.keyType();
            if (type != String.class) {
                if (type.isPrimitive() || Primitives.isWrapperType(type)) {
                    if (type == Long.class) {
                        key = Long.parseLong(String.valueOf(key));
                    }
                    if (type == Byte.class) {
                        key = Byte.parseByte(String.valueOf(key));
                    }
                    if (type == Short.class) {
                        key = Short.parseShort(String.valueOf(key));
                    }
                    if (type == Float.class) {
                        key = Float.valueOf(Float.parseFloat(String.valueOf(key)));
                    }
                    if (type == Double.class) {
                        key = Double.parseDouble(String.valueOf(key));
                    }
                    if (type == Integer.class) {
                        key = Integer.parseInt(String.valueOf(key));
                    }
                } else if (type == UUID.class) {
                    key = UUID.fromString(String.valueOf(key));
                } else if (SpigotUtil.isRegistryKeyed(type)) {
                    key = Bukkit.getRegistry(type).get(SpigotUtil.getKey(String.valueOf(key)));
                } else if (type.isEnum()) {
                    key = Enum.valueOf(type, String.valueOf(key));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
            map.put(key, loaded);
        }
    }

    private static Object deserialiseValue(PersistField field, DataKey root) {
        Class<?> type;
        Class<?> clazz = type = field.field.getType().isEnum() ? field.field.getType() : PersistenceLoader.getGenericType(field.field);
        if (field.delegate == null) {
            if (SpigotUtil.isRegistryKeyed(type)) {
                Class<?> clazz2 = type;
                Object obj = root.getRaw("");
                if (obj instanceof String) {
                    return Bukkit.getRegistry(clazz2).get(SpigotUtil.getKey(obj.toString()));
                }
            } else if (type.isEnum()) {
                Class<?> clazz3 = type;
                Object obj = root.getRaw("");
                if (obj instanceof String) {
                    try {
                        return Enum.valueOf(clazz3, obj.toString());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        return field.delegate == null ? root.getRaw("") : field.delegate.create(root);
    }

    private static void ensureDelegateLoaded(Class<? extends Persister<?>> delegateClass) {
        if (loadedDelegates.containsKey(delegateClass)) {
            return;
        }
        try {
            Constructor<Persister<?>> constructor = delegateClass.getConstructor(new Class[0]);
            constructor.setAccessible(true);
            loadedDelegates.put(delegateClass, constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
            loadedDelegates.put(delegateClass, null);
        }
    }

    private static Persister<?> getDelegate(Class<?> fieldType) {
        if (registries.containsKey(fieldType)) {
            return registries.get(fieldType);
        }
        if (Component.class.isAssignableFrom(fieldType)) {
            return registries.get(Component.class);
        }
        return loadedDelegates.get(persistRedirects.get(fieldType));
    }

    private static Persister<?> getDelegate(Field field, Class<?> fieldType) {
        DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
        if (delegate == null) {
            return PersistenceLoader.getDelegate(fieldType);
        }
        Persister<?> persister = loadedDelegates.get(delegate.value());
        return persister == null ? loadedDelegates.get(persistRedirects.get(fieldType)) : persister;
    }

    private static PersistField[] getFields(Class<?> clazz) {
        PersistField[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = PersistenceLoader.getFieldsFromClass(clazz);
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private static PersistField[] getFieldsFromClass(Class<?> clazz) {
        ArrayList toFilter = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        for (Class<?> superClass = clazz.getSuperclass(); superClass != Object.class && superClass != null; superClass = superClass.getSuperclass()) {
            toFilter.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        Iterator itr = toFilter.iterator();
        while (itr.hasNext()) {
            Field field = (Field)itr.next();
            field.setAccessible(true);
            Persist persistAnnotation = field.getAnnotation(Persist.class);
            if (persistAnnotation == null) {
                itr.remove();
                continue;
            }
            DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
            if (delegate == null) continue;
            Class<? extends Persister<?>> delegateClass = delegate.value();
            PersistenceLoader.ensureDelegateLoaded(delegateClass);
            Persister<?> in = loadedDelegates.get(delegateClass);
            if (in != null) continue;
            itr.remove();
        }
        return Collections2.transform((Collection)toFilter, x$0 -> new PersistField((Field)x$0)).toArray(new PersistField[toFilter.size()]);
    }

    private static Class<?> getGenericType(Field field) {
        if (field.getGenericType() == null || !(field.getGenericType() instanceof ParameterizedType)) {
            return field.getType();
        }
        Type[] args = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        return args.length > 0 && args[0] instanceof Class ? (Class)args[0] : field.getType();
    }

    public static <T> T load(Class<? extends T> clazz, DataKey root) {
        T instance = null;
        if (persistRedirects.containsKey(clazz)) {
            return (T)PersistenceLoader.getDelegate(clazz).create(root);
        }
        try {
            Constructor<?> constructor = constructorCache.get(clazz);
            if (constructor == null) {
                for (Constructor<?> cons : clazz.getDeclaredConstructors()) {
                    DelegatePersistence delegate = cons.getAnnotation(DelegatePersistence.class);
                    if (delegate != null) {
                        PersistenceLoader.registerPersistDelegate(clazz, delegate.value());
                        return (T)PersistenceLoader.getDelegate(clazz).create(root);
                    }
                    if (cons.getParameterCount() != 0) continue;
                    cons.setAccessible(true);
                    constructor = cons;
                    constructorCache.put(clazz, constructor);
                    break;
                }
            }
            instance = (T)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            Messaging.severe("Error creating instance for " + clazz + " using " + root);
            e.printStackTrace();
        }
        if (instance == null) {
            return null;
        }
        return PersistenceLoader.load(instance, root);
    }

    public static <T> T load(T instance, DataKey root) {
        PersistField[] fields;
        Class<?> clazz = instance.getClass();
        for (PersistField field : fields = PersistenceLoader.getFields(clazz)) {
            try {
                field.populateDefault(instance);
                PersistenceLoader.deserialise(field, instance, field.get(instance), field.getDataKey(root));
            }
            catch (Exception e) {
                if (e != loadException) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (instance instanceof Persistable) {
            ((Persistable)instance).load(root);
        }
        return instance;
    }

    public static void registerPersistDelegate(Class<?> clazz, Class<? extends Persister<?>> delegateClass) {
        persistRedirects.put(clazz, delegateClass);
        PersistenceLoader.ensureDelegateLoaded(delegateClass);
    }

    public static void save(Object instance, DataKey root) {
        PersistField[] fields;
        Class<?> clazz = instance.getClass();
        for (PersistField field : fields = PersistenceLoader.getFields(clazz)) {
            PersistenceLoader.serialise(field, field.get(instance), field.getDataKey(root));
        }
        if (instance instanceof Persistable) {
            ((Persistable)instance).save(root);
        }
    }

    private static void serialise(PersistField field, Object fieldValue, DataKey root) {
        if (fieldValue == null) {
            root.removeKey(field.key);
            return;
        }
        if (Collection.class.isAssignableFrom(field.getType())) {
            Collection collection = (Collection)fieldValue;
            root.removeKey(field.key);
            int i = 0;
            for (Object object : collection) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), object);
                ++i;
            }
        } else if (Map.class.isAssignableFrom(field.getType())) {
            Map map = (Map)fieldValue;
            root.removeKey(field.key);
            for (Map.Entry entry : map.entrySet()) {
                String key = PersistenceLoader.createRelativeKey(field.key, String.valueOf(entry.getKey()));
                PersistenceLoader.serialiseValue(field, root.getRelative(key), entry.getValue());
            }
        } else if (float[].class.isAssignableFrom(field.getType())) {
            float[] floats = (float[])fieldValue;
            root.removeKey(field.key);
            for (int i = 0; i < floats.length; ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), Float.valueOf(floats[i]));
            }
        } else if (double[].class.isAssignableFrom(field.getType())) {
            double[] doubles = (double[])fieldValue;
            root.removeKey(field.key);
            for (int i = 0; i < doubles.length; ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), doubles[i]);
            }
        } else if (int[].class.isAssignableFrom(field.getType())) {
            int[] ints = (int[])fieldValue;
            root.removeKey(field.key);
            for (int i = 0; i < ints.length; ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                PersistenceLoader.serialiseValue(field, root.getRelative(key), ints[i]);
            }
        } else {
            if (field.key.equals("$key")) {
                return;
            }
            PersistenceLoader.serialiseValue(field, root.getRelative(field.key), fieldValue);
        }
    }

    private static void serialiseValue(PersistField field, DataKey root, Object value) {
        if (field.isDefault(value)) {
            root.removeKey("");
            return;
        }
        if (field.delegate != null) {
            field.delegate.save(value, root);
        } else if (SpigotUtil.isRegistryKeyed(field.getType())) {
            NamespacedKey nskey = ((Keyed)value).getKey();
            root.setRaw("", nskey.getNamespace() + ":" + nskey.getKey());
        } else if (value instanceof Enum) {
            root.setRaw("", ((Enum)value).name());
        } else {
            if (root.getSubKeys().iterator().hasNext() && !(value instanceof Collection)) {
                return;
            }
            root.setRaw("", value);
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(Quaternionfc.class, QuaternionfPersister.class);
        PersistenceLoader.registerPersistDelegate(Vector.class, VectorPersister.class);
        PersistenceLoader.registerPersistDelegate(Component.class, ComponentPersister.class);
        PersistenceLoader.registerPersistDelegate(Location.class, LocationPersister.class);
        PersistenceLoader.registerPersistDelegate(ItemStack.class, ItemStackPersister.class);
        PersistenceLoader.registerPersistDelegate(EulerAngle.class, EulerAnglePersister.class);
        PersistenceLoader.registerPersistDelegate(UUID.class, UUIDPersister.class);
        try {
            Class.forName("org.bukkit.Keyed");
            SUPPORTS_KEYED = true;
            PersistenceLoader.registerPersistDelegate(NamespacedKey.class, NamespacedKeyPersister.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class PersistField {
        private boolean checkedForDefault;
        private Object defaultValue;
        private final Persister<?> delegate;
        private final Field field;
        private final String key;
        private final Persist persistAnnotation;
        private static final Object NULL = new Object();

        private PersistField(Field field) {
            this.field = field;
            this.persistAnnotation = field.getAnnotation(Persist.class);
            this.key = this.persistAnnotation.value().equals("UNINITIALISED") ? field.getName() : this.persistAnnotation.value();
            Class fieldType = field.getType();
            if (field.getGenericType() instanceof ParameterizedType) {
                int index = Map.class.isAssignableFrom(field.getType()) ? 1 : 0;
                fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[index];
            }
            if (this.persistAnnotation.valueType() != Object.class) {
                fieldType = this.persistAnnotation.valueType();
            }
            this.delegate = this.persistAnnotation.reify() ? new PersistenceLoaderPersister(fieldType) : PersistenceLoader.getDelegate(field, fieldType);
        }

        public <T> T get(Object instance) {
            try {
                return (T)this.field.get(instance);
            }
            catch (Exception e) {
                e.printStackTrace();
                return (T)NULL;
            }
        }

        public Class<?> getCollectionType() {
            return this.persistAnnotation.collectionType();
        }

        public DataKey getDataKey(DataKey root) {
            return this.persistAnnotation.namespace().isEmpty() ? root : root.getFromRoot("global." + this.persistAnnotation.namespace());
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public boolean isDefault(Object value) {
            return this.defaultValue != null && this.defaultValue.equals(value);
        }

        public boolean isRequired() {
            return this.persistAnnotation.required();
        }

        public void populateDefault(Object instance) {
            if (this.checkedForDefault) {
                return;
            }
            try {
                this.defaultValue = this.field.get(instance);
                this.checkedForDefault = true;
                if (!(this.defaultValue == null || this.defaultValue.getClass().isPrimitive() || this.defaultValue instanceof Number || this.defaultValue instanceof Enum || this.defaultValue instanceof Boolean || this.defaultValue instanceof String || SUPPORTS_KEYED && this.defaultValue instanceof Keyed)) {
                    this.defaultValue = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void set(Object instance, Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class PersistenceLoaderPersister
    implements Persister<Object> {
        private final Class<?> clazz;

        private PersistenceLoaderPersister(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Object create(DataKey root) {
            return PersistenceLoader.load(this.clazz, root);
        }

        @Override
        public void save(Object instance, DataKey root) {
            PersistenceLoader.save(instance, root);
        }
    }
}

