/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.objects.properties.material.internal;

import com.denizenscript.clientizen.objects.MaterialTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.ObjectProperty;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public abstract class MaterialMinecraftProperty<T extends class_2769<V>, V extends Comparable<V>>
extends ObjectProperty<MaterialTag, ElementTag> {
    public T internalProperty;
    private String propertyID;

    protected MaterialMinecraftProperty() {
    }

    public ElementTag getPropertyValue() {
        return this.rawValueToElement(this.processPropertyValue(((MaterialTag)this.object).state.method_11654(this.internalProperty)));
    }

    public ElementTag getPropertyValueNoDefault() {
        Comparable value = ((MaterialTag)this.object).state.method_11654(this.internalProperty);
        if (this.isDefaultValue(value)) {
            return null;
        }
        return this.rawValueToElement(this.processPropertyValue(value));
    }

    public boolean isDefaultValue(V value) {
        return value == ((MaterialTag)this.object).state.method_26204().method_9564().method_11654(this.internalProperty);
    }

    public String getPropertySavableValue() {
        ElementTag value = this.getPropertyValueNoDefault();
        return value == null ? null : value.savable();
    }

    public V processPropertyValue(V value) {
        return value;
    }

    public V parsePropertyValue(ElementTag input, Mechanism mechanism) {
        return (V)((Comparable)this.internalProperty.method_11900(input.asLowerString()).orElse(null));
    }

    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        V parsedValue = this.parsePropertyValue(value, mechanism);
        if (parsedValue == null) {
            mechanism.echoError("Invalid " + DebugInternals.getClassNameOpti((Class)this.internalProperty.method_11902()) + " specified, must be one of: " + this.internalProperty.method_11898().stream().map(this::processPropertyValue).filter(Objects::nonNull).map(arg_0 -> this.internalProperty.method_11901(arg_0)).collect(Collectors.joining(", ")) + ".");
            return;
        }
        ((MaterialTag)this.object).state = (class_2680)((MaterialTag)this.object).state.method_11657(this.internalProperty, parsedValue);
    }

    public String getPropertyId() {
        return this.propertyID;
    }

    private ElementTag rawValueToElement(V value) {
        return value == null ? null : new ElementTag(this.internalProperty.method_11901(value), true);
    }

    @SafeVarargs
    public static <T extends class_2769<V>, V extends Comparable<V>> void registerProperty(Class<? extends MaterialMinecraftProperty<T, V>> propertyClass, T ... properties) {
        PropertyParser.registerPropertyGetter((PropertyParser.PropertyGetter)new MaterialMinecraftPropertyGetter(propertyClass, properties), MaterialTag.class, null, null, propertyClass);
    }

    public static void autoRegister(String name, Class<? extends MaterialMinecraftProperty> propertyClass) {
        ((MaterialMinecraftPropertyGetter)PropertyParser.currentlyRegisteringProperty).propertyID = name;
        MaterialMinecraftProperty.autoRegister((String)name, propertyClass, ElementTag.class, (boolean)false, (String[])new String[0]);
    }

    public static class MaterialMinecraftPropertyGetter<T extends class_2769<V>, V extends Comparable<V>>
    implements PropertyParser.PropertyGetter<MaterialTag> {
        private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
        private static final MethodType NO_ARGS_CONSTRUCTOR = MethodType.methodType(Void.TYPE);
        private final MethodHandle constructor;
        private final T[] internalProperties;
        private String propertyID;

        public MaterialMinecraftPropertyGetter(Class<? extends MaterialMinecraftProperty<T, V>> propertyClass, T[] internalProperties) {
            try {
                this.constructor = LOOKUP.findConstructor(propertyClass, NO_ARGS_CONSTRUCTOR);
            }
            catch (Exception e) {
                Debug.echoError((String)("Unable to get constructor from material minecraft property class '" + DebugInternals.getClassNameOpti(propertyClass) + "'!"));
                throw new IllegalArgumentException(e);
            }
            this.internalProperties = internalProperties;
        }

        public ObjectProperty<MaterialTag, ElementTag> get(MaterialTag material) {
            if (material.state == null) {
                return null;
            }
            for (T internalProperty : this.internalProperties) {
                if (!material.state.method_28498(internalProperty)) continue;
                try {
                    MaterialMinecraftProperty property = this.constructor.invoke();
                    property.object = material;
                    property.internalProperty = internalProperty;
                    property.propertyID = this.propertyID;
                    return property;
                }
                catch (Throwable e) {
                    Debug.echoError((String)("Exception while constructing property '" + DebugInternals.getClassNameOpti((Class)this.constructor.type().returnType()) + "':"));
                    Debug.echoError((Throwable)e);
                    return null;
                }
            }
            return null;
        }
    }
}

