/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.clientizen.network.packets;

import com.denizenscript.clientizen.Clientizen;
import com.denizenscript.clientizen.network.Codecs;
import com.denizenscript.clientizen.network.PacketIn;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.util.Map;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record RunScriptPacketIn(String scriptName, String scriptPath, Map<String, String> definitions) implements PacketIn
{
    public static final class_8710.class_9154<RunScriptPacketIn> ID = new class_8710.class_9154(Clientizen.id("run_script"));
    public static final class_9139<class_9129, RunScriptPacketIn> CODEC = Codecs.readOnly(Codecs.STRING, Codecs.nullable(Codecs.STRING), Codecs.STRING_MAP, RunScriptPacketIn::new);

    @Override
    public void process() {
        ScriptTag script = ScriptTag.valueOf((String)this.scriptName, (TagContext)CoreUtilities.noDebugContext);
        if (script == null) {
            if (CoreConfiguration.debugExtraInfo) {
                Debug.echoError((String)("Invalid script name to run received from server: " + this.scriptName + "."));
            }
            return;
        }
        ScriptUtilities.createAndStartQueue((ScriptContainer)script.getContainer(), (String)this.scriptPath, null, null, queue -> {
            TagContext context = DenizenCore.implementation.getTagContext(script.getContainer());
            for (Map.Entry<String, String> entry : this.definitions.entrySet()) {
                queue.addDefinition(entry.getKey(), ObjectFetcher.pickObjectFor((String)entry.getValue(), (TagContext)context));
            }
        }, null, (String)("SERVER_RUN:" + script.getContainer().getName()), null, null);
    }

    public class_8710.class_9154<RunScriptPacketIn> method_56479() {
        return ID;
    }
}

