/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags.core;

import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class EscapeTagBase {
    public EscapeTagBase() {
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                EscapeTagBase.this.escapeTags(event);
            }
        }, "escape");
        TagManager.registerTagHandler(new TagRunnable.RootForm(){

            @Override
            public void run(ReplaceableTagEvent event) {
                EscapeTagBase.this.unEscapeTags(event);
            }
        }, "unescape");
    }

    public static String escape(String input) {
        if (input == null) {
            return null;
        }
        input = CoreUtilities.replace(input, "&", "&amp");
        input = CoreUtilities.replace(input, "|", "&pipe");
        input = CoreUtilities.replace(input, "<", "&lt");
        input = CoreUtilities.replace(input, ">", "&gt");
        input = CoreUtilities.replace(input, "\n", "&nl");
        input = CoreUtilities.replace(input, ";", "&sc");
        input = CoreUtilities.replace(input, "[", "&lb");
        input = CoreUtilities.replace(input, "]", "&rb");
        input = CoreUtilities.replace(input, ":", "&co");
        input = CoreUtilities.replace(input, "@", "&at");
        input = CoreUtilities.replace(input, ".", "&dot");
        input = CoreUtilities.replace(input, "\\", "&bs");
        input = CoreUtilities.replace(input, "'", "&sq");
        input = CoreUtilities.replace(input, "\"", "&quo");
        input = CoreUtilities.replace(input, "!", "&exc");
        input = CoreUtilities.replace(input, "/", "&fs");
        input = CoreUtilities.replace(input, "\u00a7", "&ss");
        input = CoreUtilities.replace(input, "#", "&ns");
        return input;
    }

    public static String unEscape(String input) {
        if (input == null) {
            return null;
        }
        input = CoreUtilities.replace(input, "&pipe", "|");
        input = CoreUtilities.replace(input, "&lt", "<");
        input = CoreUtilities.replace(input, "&gt", ">");
        input = CoreUtilities.replace(input, "&nl", "\n");
        input = CoreUtilities.replace(input, "&sc", ";");
        input = CoreUtilities.replace(input, "&lb", "[");
        input = CoreUtilities.replace(input, "&rb", "]");
        input = CoreUtilities.replace(input, "&co", ":");
        input = CoreUtilities.replace(input, "&at", "@");
        input = CoreUtilities.replace(input, "&dot", ".");
        input = CoreUtilities.replace(input, "&bs", "\\");
        input = CoreUtilities.replace(input, "&sq", "'");
        input = CoreUtilities.replace(input, "&quo", "\"");
        input = CoreUtilities.replace(input, "&exc", "!");
        input = CoreUtilities.replace(input, "&fs", "/");
        input = CoreUtilities.replace(input, "&ss", "\u00a7");
        input = CoreUtilities.replace(input, "&ns", "#");
        input = CoreUtilities.replace(input, "&sp", CoreUtilities.NBSP);
        input = CoreUtilities.replace(input, "&amp", "&");
        return input;
    }

    public void escapeTags(ReplaceableTagEvent event) {
        Deprecations.oldEscapeTags.warn(event.getScriptEntry());
        if (event.matches("escape")) {
            if (!event.hasValue()) {
                Debug.echoError("Escape tag '" + event.raw_tag + "' does not have a value!");
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(EscapeTagBase.escape(event.getValue())), event.getAttributes().fulfill(1)));
        }
    }

    public void unEscapeTags(ReplaceableTagEvent event) {
        Deprecations.oldEscapeTags.warn(event.getScriptEntry());
        if (event.matches("unescape")) {
            if (!event.hasValue()) {
                Debug.echoError("Unescape tag '" + event.raw_tag + "' does not have a value!");
                return;
            }
            event.setReplacedObject(CoreUtilities.autoAttrib(new ElementTag(EscapeTagBase.unEscape(event.getValue())), event.getAttributes().fulfill(1)));
        }
    }
}

