/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.Adjustable;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;

public class TimeTag
implements ObjectTag,
Adjustable {
    public ZonedDateTime instant;
    public static ZoneId UTC_Zone = ZoneId.of("UTC");
    String prefix = "Time";
    public static ObjectTagProcessor<TimeTag> tagProcessor = new ObjectTagProcessor();

    public static TimeTag now() {
        return new TimeTag(ZonedDateTime.now());
    }

    public static TimeTag valueOf(String string) {
        return TimeTag.valueOf(string, null);
    }

    @Fetchable(value="time")
    public static TimeTag valueOf(String string, TagContext context) {
        List<String> coreParts;
        if (string == null) {
            return null;
        }
        if (string.startsWith("time@") && string.length() > "time@".length()) {
            string = string.substring("time@".length());
        }
        if ((coreParts = CoreUtilities.split(string, '_')).size() != 3) {
            return null;
        }
        List<String> dateParts = CoreUtilities.split(coreParts.get(0), '/');
        if (dateParts.size() != 3) {
            return null;
        }
        List<String> timeParts = CoreUtilities.split(coreParts.get(1), ':');
        if (timeParts.size() != 3 && timeParts.size() != 4) {
            return null;
        }
        try {
            int year = Integer.parseInt(dateParts.get(0));
            int month = Integer.parseInt(dateParts.get(1));
            int day = Integer.parseInt(dateParts.get(2));
            int hour = Integer.parseInt(timeParts.get(0));
            int minute = Integer.parseInt(timeParts.get(1));
            int second = Integer.parseInt(timeParts.get(2));
            int millisecond = timeParts.size() == 3 ? 0 : Integer.parseInt(timeParts.get(3));
            ZoneOffset offset = ZoneOffset.of(coreParts.get(2));
            ZonedDateTime dateTime = ZonedDateTime.of(year, month, day, hour, minute, second, millisecond * 1000000, offset);
            return new TimeTag(dateTime);
        }
        catch (NumberFormatException ex) {
            if (context == null || context.debug) {
                Debug.echoError(ex);
            }
            return null;
        }
    }

    public static boolean matches(String string) {
        if (CoreUtilities.toLowerCase(string).startsWith("time@")) {
            return true;
        }
        return TimeTag.valueOf(string, CoreUtilities.noDebugContext) != null;
    }

    public TimeTag() {
    }

    public TimeTag(ZonedDateTime instant) {
        this.instant = instant;
    }

    public TimeTag(long millis) {
        this(Instant.ofEpochSecond(millis / 1000L, millis % 1000L * 1000000L).atZone(UTC_Zone));
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public TimeTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public String getObjectType() {
        return "time";
    }

    public static String pad0(int value, int len) {
        String outputStr = String.valueOf(value);
        while (outputStr.length() < len) {
            outputStr = "0" + outputStr;
        }
        return outputStr;
    }

    @Override
    public String debuggable() {
        StringBuilder output = new StringBuilder();
        output.append("<G>time@ <Y>");
        output.append(TimeTag.pad0(this.instant.get(ChronoField.YEAR), 4)).append("<G> / <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.MONTH_OF_YEAR), 2)).append(" <G>(<GR>").append(Month.of(this.instant.get(ChronoField.MONTH_OF_YEAR)).name()).append("<G>)").append("<G> / <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.DAY_OF_MONTH), 2)).append(" <G>(<GR>").append(DayOfWeek.of(this.instant.get(ChronoField.DAY_OF_WEEK)).name()).append("<G>)").append("<G> _ <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.HOUR_OF_DAY), 2)).append("<G> : <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.MINUTE_OF_HOUR), 2)).append("<G> : <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.SECOND_OF_MINUTE), 2)).append("<G> : <Y>").append(TimeTag.pad0(this.instant.get(ChronoField.MILLI_OF_SECOND), 4)).append("<G> _ <Y>").append(this.instant.getOffset().getId());
        return output.toString();
    }

    @Override
    public String identify() {
        StringBuilder output = new StringBuilder();
        output.append("time@");
        output.append(TimeTag.pad0(this.instant.get(ChronoField.YEAR), 4)).append("/").append(TimeTag.pad0(this.instant.get(ChronoField.MONTH_OF_YEAR), 2)).append("/").append(TimeTag.pad0(this.instant.get(ChronoField.DAY_OF_MONTH), 2)).append("_").append(TimeTag.pad0(this.instant.get(ChronoField.HOUR_OF_DAY), 2)).append(":").append(TimeTag.pad0(this.instant.get(ChronoField.MINUTE_OF_HOUR), 2)).append(":").append(TimeTag.pad0(this.instant.get(ChronoField.SECOND_OF_MINUTE), 2)).append(":").append(TimeTag.pad0(this.instant.get(ChronoField.MILLI_OF_SECOND), 4)).append("_").append(this.instant.getOffset().getId());
        return output.toString();
    }

    @Override
    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public static void registerTags() {
        TimeTag.registerTag("year", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.YEAR)), new String[0]);
        TimeTag.registerTag("month", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.MONTH_OF_YEAR)), new String[0]);
        TimeTag.registerTag("month_name", (attribute, object) -> new ElementTag(Month.of(object.instant.get(ChronoField.MONTH_OF_YEAR)).name()), new String[0]);
        TimeTag.registerTag("day", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.DAY_OF_MONTH)), new String[0]);
        TimeTag.registerTag("day_of_week", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.DAY_OF_WEEK)), new String[0]);
        TimeTag.registerTag("day_of_week_name", (attribute, object) -> new ElementTag(DayOfWeek.of(object.instant.get(ChronoField.DAY_OF_WEEK)).name()), new String[0]);
        TimeTag.registerTag("hour", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.HOUR_OF_DAY)), new String[0]);
        TimeTag.registerTag("minute", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.MINUTE_OF_HOUR)), new String[0]);
        TimeTag.registerTag("second", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.SECOND_OF_MINUTE)), new String[0]);
        TimeTag.registerTag("millisecond", (attribute, object) -> new ElementTag(object.instant.get(ChronoField.MILLI_OF_SECOND)), new String[0]);
        TimeTag.registerTag("epoch_millis", (attribute, object) -> new ElementTag(object.millis()), new String[0]);
        TimeTag.registerTag("time_zone_offset", (attribute, object) -> new ElementTag(object.instant.getOffset().getId()), new String[0]);
        TimeTag.registerTag("time_zone_id", (attribute, object) -> new ElementTag(object.instant.getZone().getId()), new String[0]);
        TimeTag.registerTag("time_zone_name", (attribute, object) -> new ElementTag(object.instant.getZone().getDisplayName(TextStyle.SHORT, Locale.ENGLISH)), new String[0]);
        TimeTag.registerTag("to_zone", (attribute, object) -> new TimeTag(object.instant.withZoneSameInstant(ZoneId.of(attribute.getContext(1)))), new String[0]);
        TimeTag.registerTag("to_local", (attribute, object) -> new TimeTag(object.instant.withZoneSameInstant(ZoneId.systemDefault())), new String[0]);
        TimeTag.registerTag("to_utc", (attribute, object) -> new TimeTag(object.instant.withZoneSameInstant(ZoneOffset.UTC)), new String[0]);
        TimeTag.registerTag("add", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.add[...] must have an input.");
                return null;
            }
            DurationTag toAdd = DurationTag.valueOf(attribute.getContext(1), attribute.context);
            return new TimeTag(object.millis() + toAdd.getMillis());
        }, new String[0]);
        TimeTag.registerTag("sub", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.sub[...] must have an input.");
                return null;
            }
            DurationTag toSub = DurationTag.valueOf(attribute.getContext(1), attribute.context);
            return new TimeTag(object.millis() - toSub.getMillis());
        }, new String[0]);
        TimeTag.registerTag("duration_since", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.duration_since[...] must have an input.");
                return null;
            }
            TimeTag toSub = TimeTag.valueOf(attribute.getContext(1), attribute.context);
            return new DurationTag((double)(object.millis() - toSub.millis()) / 1000.0);
        }, new String[0]);
        TimeTag.registerTag("format", (attribute, object) -> {
            if (!attribute.hasContext(1)) {
                attribute.echoError("The tag TimeTag.format[...] must have an input.");
                return null;
            }
            DateTimeFormatter format = DateTimeFormatter.ofPattern(attribute.getContext(1));
            return new ElementTag(object.instant.format(format));
        }, new String[0]);
        TimeTag.registerTag("duration_compat", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return new DurationTag((double)object.millis() / 1000.0);
        }, "in_years", "in_weeks", "in_days", "in_hours", "in_minutes", "in_seconds", "in_milliseconds", "in_ticks");
        TimeTag.registerTag("time", (attribute, object) -> {
            Deprecations.timeTagRewrite.warn(attribute.context);
            return object;
        }, new String[0]);
    }

    public long millis() {
        return this.instant.toEpochSecond() * 1000L + (long)(this.instant.getNano() / 1000000);
    }

    public static void registerTag(String name, TagRunnable.ObjectInterface<TimeTag> runnable, String ... variants) {
        tagProcessor.registerTag(name, runnable, variants);
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute(this, attribute);
    }

    @Override
    public void applyProperty(Mechanism mechanism) {
        Debug.echoError("TimeTags can not hold properties.");
    }

    @Override
    public void adjust(Mechanism mechanism) {
        CoreUtilities.autoPropertyMechanism(this, mechanism);
    }
}

