/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.containers;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.scripts.ScriptEntrySet;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.YamlConfiguration;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScriptContainer
implements Debuggable {
    public boolean canRunScripts = true;
    YamlConfiguration contents;
    private String name;
    public ScriptEntrySet baseEntries = null;
    private Map<String, ScriptEntrySet> scriptsMap = new HashMap<String, ScriptEntrySet>();
    private Boolean shouldDebug = null;

    public ScriptContainer(YamlConfiguration configurationSection, String scriptContainerName) {
        if (configurationSection == null) {
            Debug.echoError("Null configuration section while generating a ScriptContainer?!");
            throw new RuntimeException("Null configuration section while generating a ScriptContainer");
        }
        this.contents = configurationSection;
        configurationSection.forceLoweredRootKey("type");
        configurationSection.forceLoweredRootKey("debug");
        configurationSection.forceLoweredRootKey("script");
        configurationSection.forceLoweredRootKey("speed");
        this.name = scriptContainerName.toUpperCase();
    }

    public YamlConfiguration getContents() {
        return this.contents;
    }

    public <T extends ScriptContainer> T getAsContainerType(Class<T> type) {
        return (T)((ScriptContainer)type.cast(this));
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return ScriptHelper.getSource(this.getName());
    }

    public String getRelativeFileName() {
        try {
            String fn = this.getFileName().replace(DenizenCore.getImplementation().getScriptFolder().getParentFile().getCanonicalPath(), "");
            while (fn.startsWith("/")) {
                fn = fn.substring(1);
            }
            return fn;
        }
        catch (Exception e) {
            Debug.echoError(e);
            return this.getFileName();
        }
    }

    public String getOriginalName() {
        return ScriptHelper.getOriginalName(this.getName());
    }

    public ScriptTag getAsScriptArg() {
        return ScriptTag.valueOf(this.name);
    }

    public String getContainerType() {
        return this.contents.contains("type") ? this.contents.getString("type").toUpperCase() : null;
    }

    public boolean contains(String path) {
        return this.contents.contains(path);
    }

    public String getString(String path) {
        return this.contents.getString(path);
    }

    public String getString(String path, String def) {
        return this.contents.getString(path, def);
    }

    public List<String> getStringList(String path) {
        List<String> strs = this.contents.getStringList(path);
        if (strs == null) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>(strs.size());
        for (String str : strs) {
            output.add(ScriptBuilder.stripLinePrefix(str));
        }
        return output;
    }

    public YamlConfiguration getConfigurationSection(String path) {
        if (path.length() == 0) {
            return this.contents;
        }
        return this.contents.getConfigurationSection(path);
    }

    public void set(String path, Object object) {
        this.contents.set(path, object);
    }

    public List<ScriptEntry> getBaseEntries(ScriptEntryData data) {
        if (this.baseEntries == null) {
            this.baseEntries = this.getSetFor("script");
        }
        return ScriptContainer.cleanDup(data, this.baseEntries);
    }

    public static List<ScriptEntry> cleanDup(ScriptEntryData data, ScriptEntrySet set) {
        if (set == null) {
            return null;
        }
        set = set.duplicate();
        for (ScriptEntry entry : set.entries) {
            entry.entryData = data.clone();
            entry.updateContext();
            entry.entryData.scriptEntry = entry;
        }
        return set.entries;
    }

    public List<ScriptEntry> getEntries(ScriptEntryData data, String path) {
        if (path == null) {
            path = "script";
        }
        return ScriptContainer.cleanDup(data, this.getSetFor(path));
    }

    public ScriptEntrySet getSetFor(String path) {
        ScriptEntrySet got = this.scriptsMap.get(path);
        if (got != null) {
            return got;
        }
        List<Object> stringEntries = this.contents.getList(path);
        if (stringEntries == null || stringEntries.isEmpty()) {
            return null;
        }
        List<ScriptEntry> entries = ScriptBuilder.buildScriptEntries(stringEntries, this, null);
        got = new ScriptEntrySet(entries);
        this.scriptsMap.put(path, got);
        return got;
    }

    @Override
    public boolean shouldDebug() {
        if (this.shouldDebug == null) {
            this.shouldDebug = !this.contents.contains("debug") ? Boolean.valueOf(DenizenCore.getImplementation().getDefaultDebugMode()) : Boolean.valueOf(!this.contents.getString("debug").equalsIgnoreCase("false"));
        }
        return this.shouldDebug;
    }

    public String toString() {
        return "s@" + CoreUtilities.toLowerCase(this.getName());
    }
}

