/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.CustomObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.QueueTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.ScriptBuilder;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class CoreUtilities {
    public static TagContext noDebugContext;
    public static TagContext basicContext;
    public static DecimalFormatSymbols decimalFormatSymbols;
    public static final char NBSP_Char = '\u00a0';
    public static final String NBSP;
    public static final Map<Class<? extends ObjectTag>, TypeComparisonRunnable> typeCheckers;
    static Random random;
    static FilenameFilter scriptsFilter;
    public static DecimalFormat df;

    public static String clearNBSPs(String input) {
        return input.replace('\u00a0', ' ');
    }

    public static ObjectTag objectToTagForm(Object obj, TagContext context) {
        return CoreUtilities.objectToTagForm(obj, context, false);
    }

    public static ObjectTag objectToTagForm(Object obj, TagContext context, boolean scriptStrip) {
        if (obj == null) {
            return new ElementTag("null");
        }
        if (obj instanceof List) {
            ListTag listResult = new ListTag();
            for (Object subObj : (List)obj) {
                listResult.addObject(CoreUtilities.objectToTagForm(subObj, context, scriptStrip));
            }
            return listResult;
        }
        if (obj instanceof Map) {
            MapTag result = new MapTag();
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (scriptStrip) {
                    key = ScriptBuilder.stripLinePrefix(key);
                }
                result.map.put(new StringHolder(key), CoreUtilities.objectToTagForm(entry.getValue(), context));
            }
            return result;
        }
        String result = obj.toString();
        if (scriptStrip) {
            result = ScriptBuilder.stripLinePrefix(result);
        }
        return ObjectFetcher.pickObjectFor(result, context);
    }

    public static Object objectTagToJavaForm(ObjectTag obj, boolean stringHolder) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ListTag) {
            ArrayList<Object> output = new ArrayList<Object>(((ListTag)obj).size());
            for (ObjectTag entry : ((ListTag)obj).objectForms) {
                output.add(CoreUtilities.objectTagToJavaForm(entry, stringHolder));
            }
            return output;
        }
        if (obj instanceof MapTag) {
            LinkedHashMap<Object, Object> output = new LinkedHashMap<Object, Object>();
            for (Map.Entry<StringHolder, ObjectTag> entry : ((MapTag)obj).map.entrySet()) {
                output.put(stringHolder ? entry.getKey() : entry.getKey().str, CoreUtilities.objectTagToJavaForm(entry.getValue(), stringHolder));
            }
            return output;
        }
        return obj.toString();
    }

    public static String splitLinesByCharacterCount(String str, int length) {
        if (length < 3) {
            return str;
        }
        StringBuilder output = new StringBuilder(str.length() * 2);
        int curLineLen = 0;
        int lineStart = 0;
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n') {
                output.append(str, lineStart, i + 1);
                curLineLen = 0;
                lineStart = i + 1;
                continue;
            }
            if (++curLineLen <= length) continue;
            for (int x = i - 1; x > lineStart; --x) {
                char xc = str.charAt(x);
                if (xc != ' ') continue;
                output.append(str, lineStart, x).append("\n");
                curLineLen = 0;
                lineStart = x + 1;
                i = x;
                continue block0;
            }
            output.append(str, lineStart, i).append("\n");
            curLineLen = 0;
            lineStart = i;
        }
        output.append(str, lineStart, str.length());
        return output.toString();
    }

    public static void fixNewLinesToListSeparation(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            String line = (String)list.get(i);
            if (!line.contains("\n")) continue;
            List<String> split = CoreUtilities.split(line, '\n');
            list.set(i, split.get(0));
            for (int x = 1; x < split.size(); ++x) {
                list.add(i + x, split.get(x));
            }
        }
    }

    public static String replace(String original, String findMe, String swapMeIn) {
        int lastIndex = original.indexOf(findMe);
        while (lastIndex >= 0) {
            original = original.substring(0, lastIndex) + swapMeIn + original.substring(lastIndex + findMe.length());
            lastIndex = original.indexOf(findMe, lastIndex + swapMeIn.length());
        }
        return original;
    }

    public static String join(String delim, List objects) {
        StringBuilder output = new StringBuilder(objects.size() * 5);
        for (int i = 0; i < objects.size(); ++i) {
            output.append(objects.get(i));
            if (i + 1 >= objects.size()) continue;
            output.append(delim);
        }
        return output.toString();
    }

    public static String stringifyNullPass(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static ObjectTag fixType(ObjectTag input, TagContext context) {
        if (input instanceof ElementTag) {
            return ObjectFetcher.pickObjectFor(input.toString(), context);
        }
        return input;
    }

    public static void autoPropertyMechanism(ObjectTag object, Mechanism mechanism) {
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return;
        }
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByMechanism.get(mechanism.getName());
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                return;
            }
            prop.adjust(mechanism);
            return;
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyMechs) {
            Property prop = listGetter.get(object);
            if (prop == null) continue;
            prop.adjust(mechanism);
            if (!mechanism.fulfilled()) continue;
            return;
        }
    }

    public static ObjectTag autoPropertyTagObject(ObjectTag object, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return null;
        }
        String tagName = attribute.getAttributeWithoutContext(1);
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByTag.get(tagName);
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                String propName = properties.propertyNamesByTag.get(tagName);
                attribute.seemingSuccesses.add(attribute.getAttributeWithoutContext(1) + " - property " + propName + " matched, but is not valid for the object.");
                return null;
            }
            return prop.getObjectAttribute(attribute);
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyTags) {
            ObjectTag returned;
            Property prop = listGetter.get(object);
            if (prop == null || (returned = prop.getObjectAttribute(attribute)) == null) continue;
            return returned;
        }
        return null;
    }

    public static String autoPropertyTag(ObjectTag object, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        PropertyParser.ClassPropertiesInfo properties = PropertyParser.propertiesByClass.get(object.getObjectTagClass());
        if (properties == null) {
            return null;
        }
        String tagName = attribute.getAttributeWithoutContext(1);
        PropertyParser.PropertyGetter specificGetter = properties.propertiesByTag.get(tagName);
        if (specificGetter != null) {
            Property prop = specificGetter.get(object);
            if (prop == null) {
                String propName = properties.propertyNamesByTag.get(tagName);
                attribute.seemingSuccesses.add(attribute.getAttributeWithoutContext(1) + " - property " + propName + " matched, but is not valid for the object.");
                return null;
            }
            return prop.getAttribute(attribute);
        }
        for (PropertyParser.PropertyGetter listGetter : properties.propertiesAnyTags) {
            String returned;
            Property prop = listGetter.get(object);
            if (prop == null || (returned = prop.getAttribute(attribute)) == null) continue;
            return returned;
        }
        return null;
    }

    public static ObjectTag autoAttrib(Property inp, Attribute attribute) {
        if (attribute.isComplete()) {
            return null;
        }
        return inp.getObjectAttribute(attribute);
    }

    public static ObjectTag autoAttribTyped(ObjectTag inp, Attribute attribute) {
        return CoreUtilities.autoAttrib(CoreUtilities.fixType(inp, attribute.context), attribute);
    }

    public static ObjectTag autoAttrib(ObjectTag inp, Attribute attribute) {
        if (inp == null) {
            Debug.echoError("Tag parse failed (null return) for tag <" + attribute.toString() + ">!");
            return null;
        }
        if (attribute.isComplete()) {
            return inp;
        }
        return inp.getObjectAttribute(attribute);
    }

    public static <T extends ObjectTag> T asType(ObjectTag inp, Class<T> type, TagContext context) {
        if (inp.getObjectTagClass() == type) {
            return (T)inp;
        }
        if (type == ElementTag.class) {
            return (T)new ElementTag(inp.toString());
        }
        return ObjectFetcher.getObjectFrom(type, inp.toString(), context);
    }

    public static void registerTypeAsNoOtherTypeCode(Class<? extends ObjectTag> type, final String knownCode) {
        typeCheckers.put(type, new TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                String code;
                String simple = inp.identifySimple();
                int atIndex = simple.indexOf(64);
                return atIndex == -1 || (code = simple.substring(0, atIndex)).equals(knownCode);
            }
        });
    }

    public static void registerTypeAsTrueAlways(Class<? extends ObjectTag> type) {
        typeCheckers.put(type, new TypeComparisonRunnable(){

            @Override
            public boolean canBecome(ObjectTag inp) {
                return true;
            }
        });
    }

    public static boolean canPossiblyBeType(ObjectTag inp, Class<? extends ObjectTag> type) {
        if (inp.getObjectTagClass() == type) {
            return true;
        }
        TypeComparisonRunnable comp = typeCheckers.get(type);
        if (comp != null && !comp.canBecome(inp)) {
            return false;
        }
        return ObjectFetcher.checkMatch(type, inp.toString());
    }

    public static void deleteDirectory(File directory) throws IOException {
        Files.walkFileTree(directory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        CoreUtilities.copyDirectory(source.toPath(), destination.toPath());
    }

    public static void copyDirectory(Path source, Path destination) throws IOException {
        Files.walk(source, new FileVisitOption[0]).forEach(file -> {
            try {
                Files.copy(file, destination.resolve(source.relativize((Path)file)), new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public static Random getRandom() {
        return random;
    }

    public static String bigDecToString(BigDecimal input) {
        String temp = input.toString();
        if (CoreUtilities.contains(temp, '.')) {
            for (int i = temp.length() - 1; i >= 0; --i) {
                if (temp.charAt(i) == '0') continue;
                if (temp.charAt(i) == '.') {
                    return temp.substring(0, i);
                }
                return temp.substring(0, i + 1);
            }
        }
        return temp;
    }

    public static String doubleToString(double input) {
        return df.format(input);
    }

    public static List<File> listDScriptFiles(File dir) {
        File[] entries;
        ArrayList<File> files = new ArrayList<File>();
        for (File file : entries = dir.listFiles()) {
            if (scriptsFilter == null || scriptsFilter.accept(dir, file.getName())) {
                files.add(file);
            }
            if (!file.isDirectory()) continue;
            files.addAll(CoreUtilities.listDScriptFiles(file));
        }
        return files;
    }

    public static boolean contains(String str, char c) {
        return str.indexOf(c) >= 0;
    }

    public static String concat(List<String> str, String split) {
        StringBuilder sb = new StringBuilder();
        if (str.size() > 0) {
            sb.append(str.get(0));
        }
        for (int i = 1; i < str.size(); ++i) {
            sb.append(split).append(str.get(i));
        }
        return sb.toString();
    }

    public static List<String> split(String str, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
        }
        strings.add(str.substring(start));
        return strings;
    }

    public static List<String> split(String str, char c, int max) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
            if (strings.size() + 1 == max) break;
        }
        strings.add(str.substring(start));
        if (Debug.verbose) {
            Debug.log("Splitting " + str + " around " + c + " limited to " + max + " returns " + CoreUtilities.concat(strings, ":::"));
        }
        return strings;
    }

    public static String toLowerCase(String input) {
        char[] data = input.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 'A' || data[i] > 'Z') continue;
            int n = i;
            data[n] = (char)(data[n] - -32);
        }
        return new String(data);
    }

    public static String getXthArg(int argc, String args) {
        char[] data = args.toCharArray();
        StringBuilder nArg = new StringBuilder();
        int arg = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                if (++arg <= argc) continue;
                return nArg.toString();
            }
            if (arg != argc) continue;
            nArg.append(data[i]);
        }
        return nArg.toString();
    }

    public static boolean xthArgEquals(int argc, String args, String input) {
        char[] data = args.toCharArray();
        char[] data2 = input.toCharArray();
        int arg = 0;
        int x = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == ' ') {
                ++arg;
                continue;
            }
            if (arg != argc) continue;
            if (x == data2.length) {
                return false;
            }
            if (data2[x++] == data[i]) continue;
            return false;
        }
        return x == data2.length;
    }

    public static String getClosestOption(List<String> strs, String opt) {
        int minDist = Integer.MAX_VALUE;
        opt = CoreUtilities.toLowerCase(opt);
        String closest = "";
        for (String cmd : strs) {
            String comp = CoreUtilities.toLowerCase(cmd);
            int distance = CoreUtilities.getLevenshteinDistance(opt, comp);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = cmd;
        }
        return closest;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int i;
        if (s == null || t == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        for (i = 0; i <= n; ++i) {
            p[i] = i;
        }
        for (int j = 1; j <= m; ++j) {
            char t_j = t.charAt(j - 1);
            d[0] = j;
            for (i = 1; i <= n; ++i) {
                int cost = s.charAt(i - 1) == t_j ? 0 : 1;
                d[i] = Math.min(Math.min(d[i - 1] + 1, p[i] + 1), p[i - 1] + cost);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        return p[n];
    }

    static {
        decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        NBSP = String.valueOf('\u00a0');
        typeCheckers = new HashMap<Class<? extends ObjectTag>, TypeComparisonRunnable>();
        CoreUtilities.registerTypeAsTrueAlways(ElementTag.class);
        CoreUtilities.registerTypeAsTrueAlways(ListTag.class);
        CoreUtilities.registerTypeAsNoOtherTypeCode(ScriptTag.class, "s");
        CoreUtilities.registerTypeAsNoOtherTypeCode(DurationTag.class, "d");
        CoreUtilities.registerTypeAsNoOtherTypeCode(CustomObjectTag.class, "custom");
        CoreUtilities.registerTypeAsNoOtherTypeCode(QueueTag.class, "q");
        random = new Random();
        scriptsFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                if (fileName.startsWith(".")) {
                    return false;
                }
                String ext = fileName.substring(fileName.lastIndexOf(46) + 1);
                if (ext.equalsIgnoreCase("DSCRIPT")) {
                    Debug.echoError("'.dscript' extension has never been officially supported. Please use '.dsc'. Regarding file " + fileName);
                    return true;
                }
                return ext.equalsIgnoreCase("YML") || ext.equalsIgnoreCase("DSC");
            }
        };
        df = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
        df.setMaximumFractionDigits(340);
    }

    public static abstract class TypeComparisonRunnable {
        public abstract boolean canBecome(ObjectTag var1);
    }
}

