/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bxe>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bxe>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bxe> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k2 -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bxe> entityClass, String name) {
        Class<? extends bxe> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bxe.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bxe.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bxe.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bxe.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bxe.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bxe.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bxe.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bxe.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bxz.class, 8, "width");
        EntityDataNameMapper.registerDataName(bxz.class, 9, "height");
        EntityDataNameMapper.registerDataName(bxz.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bxb.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(bxb.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(bxb.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(bxb.class, 11, "translation");
        EntityDataNameMapper.registerDataName(bxb.class, 12, "scale");
        EntityDataNameMapper.registerDataName(bxb.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(bxb.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(bxb.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(bxb.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(bxb.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(bxb.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(bxb.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(bxb.class, 20, "width");
        EntityDataNameMapper.registerDataName(bxb.class, 21, "height");
        EntityDataNameMapper.registerDataName(bxb.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(bxb.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(bxb.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(bxb.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(bxb.k.class, 23, "text");
        EntityDataNameMapper.registerDataName(bxb.k.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(bxb.k.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(bxb.k.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(bxb.k.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(ctl.class, 8, "item");
        EntityDataNameMapper.registerDataName(csw.class, 8, "item");
        EntityDataNameMapper.registerDataName(csy.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bww.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bww.class, 9, "color");
        EntityDataNameMapper.registerDataName(bww.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bww.class, 11, "particle");
        EntityDataNameMapper.registerDataName(csz.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(csz.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(csq.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(csq.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cst.class, 10, "color");
        EntityDataNameMapper.registerDataName(ctr.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(ctr.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cux.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cux.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cux.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cux.class, 11, "type");
        EntityDataNameMapper.registerDataName(cux.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cux.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cux.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(cnf.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(cnf.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cth.class, 8, "item");
        EntityDataNameMapper.registerDataName(csx.class, 8, "item");
        EntityDataNameMapper.registerDataName(cts.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(csy.class, 8, "item");
        EntityDataNameMapper.registerDataName(csy.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(csy.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(cog.class, 8, "item");
        EntityDataNameMapper.registerDataName(cog.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(coi.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(byf.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(byf.class, 9, "health");
        EntityDataNameMapper.registerDataName(byf.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(byf.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(byf.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(byf.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(byf.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(csi.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(csi.class, 16, "score");
        EntityDataNameMapper.registerDataName(csi.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(csi.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(csi.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(csi.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(coc.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(coc.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(coc.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(coc.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(coc.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(coc.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(coc.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(byh.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(cjo.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(cki.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(cki.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(cki.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(cjr.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(cku.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(clb.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bwu.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cmu.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(cmu.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(cme.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(cmg.class, 18, "variant");
        EntityDataNameMapper.registerDataName(clp.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(clp.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(cmd.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(cmh.class, 19, "strength");
        EntityDataNameMapper.registerDataName(cmh.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(cmh.class, 21, "variant");
        EntityDataNameMapper.registerDataName(clk.class, 17, "variant");
        EntityDataNameMapper.registerDataName(clk.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(clk.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(cjw.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(cjw.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(ckk.class, 17, "type");
        EntityDataNameMapper.registerDataName(ckk.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(ckk.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(ckk.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(cls.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cls.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(ckn.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(cko.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(cko.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(cko.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(cko.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(cko.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(cko.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(ckq.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(ckq.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(ckv.class, 17, "type");
        EntityDataNameMapper.registerDataName(clc.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(clc.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(clc.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(clc.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(clc.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(clc.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(ckt.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(cqr.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(ckm.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cmr.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(cpx.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(cpx.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(cpx.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bzb.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bzb.class, 18, "owner");
        EntityDataNameMapper.registerDataName(cjy.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cjy.class, 20, "lying");
        EntityDataNameMapper.registerDataName(cjy.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(cjy.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cmx.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cmx.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cmx.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(ckp.class, 19, "variant");
        EntityDataNameMapper.registerDataName(crp.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cru.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(ckl.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(cky.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(cpq.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(cpq.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(cpq.class, 18, "peek");
        EntityDataNameMapper.registerDataName(cpq.class, 19, "color");
        EntityDataNameMapper.registerDataName(cqw.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cqx.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cqx.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cqx.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cot.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(cow.class, 16, "state");
        EntityDataNameMapper.registerDataName(cow.class, 17, "charged");
        EntityDataNameMapper.registerDataName(cow.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(cma.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cma.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(cma.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(cpg.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(cpg.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(ctz.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(cpn.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cpu.class, 17, "spell");
        EntityDataNameMapper.registerDataName(cqa.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(cpy.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(cpv.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(crl.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(coa.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(coa.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(coa.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(coa.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(cqc.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cqd.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cqd.class, 17, "type");
        EntityDataNameMapper.registerDataName(cqd.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(cqe.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(cqe.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(cpa.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(cpa.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cpa.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cng.class, 16, "phase");
        EntityDataNameMapper.registerDataName(cpe.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(cpm.class, 16, "size");
        EntityDataNameMapper.registerDataName(cpt.class, 16, "size");
        EntityDataNameMapper.registerDataName(cuv.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cuv.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cuv.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cuv.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cuv.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cuv.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cvg.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(cvf.class, 14, "command");
        EntityDataNameMapper.registerDataName(cvf.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cop.class, 8, "fuse_ticks");
    }
}

