/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(dlm.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, dlm.d.class, Float.TYPE});
    public jg<dlm> biomeHolder;
    public asb world;

    public BiomeNMSImpl(asb world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = world.J_().f(mi.aG).a(alq.a((alq)mi.aG, (alr)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        dlm.c precipitation = ((dlm)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location), this.world.P());
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case dlm.c.b -> BiomeNMS.DownfallType.RAIN;
            case dlm.c.c -> BiomeNMS.DownfallType.SNOW;
            case dlm.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((dlm)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((dlm)this.biomeHolder.a()).h();
    }

    public float getTemperatureAt(Location location) {
        return ((dlm)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location), this.world.P());
    }

    public boolean hasDownfall() {
        return ((dlm)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(byi.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(byi.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(byi.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(byi.f);
    }

    public int getFoliageColor() {
        if (((dlm)this.biomeHolder.a()).f() != 0) {
            return ((dlm)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, dlm.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(dlm.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(dls.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((dlm)this.biomeHolder.a()).i(), Optional.of(color));
    }

    public int getFogColor() {
        return ((dlm)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(dls.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((dlm)this.biomeHolder.a()).i(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((dlm)this.biomeHolder.a()).k();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(dls.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((dlm)this.biomeHolder.a()).i(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(byi creatureType) {
        dly mobs = ((dlm)this.biomeHolder.a()).b();
        btm typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (btl meta : typeSettingList.d()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((bxn)((dly.c)meta.a()).a()));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        edx chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        iw pos = new iw(block.getX(), 0, block.getZ());
        if (this.world.C(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.i();
        }
    }

    public dlm.d getTemperatureModifier() {
        return ((dlm)this.biomeHolder.a()).i.c();
    }
}

