/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class BlockDestroyedByExplosionEvent
extends BukkitScriptEvent
implements Listener {
    public BlockExplodeEvent blockEvent;
    public EntityExplodeEvent entityEvent;
    public LocationTag location;
    public List<Block> rawList;

    public BlockDestroyedByExplosionEvent() {
        this.registerCouldMatcher("<block> destroyed by explosion");
        this.registerSwitches("source_entity", "source_block");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(0, this.location)) {
            return false;
        }
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (path.switches.containsKey("source_entity") && (this.entityEvent == null || !new EntityTag(this.entityEvent.getEntity()).tryAdvancedMatcher(path.switches.get("source_entity"), path.context))) {
            return false;
        }
        if (path.switches.containsKey("source_block") && (this.blockEvent == null || !new LocationTag(this.blockEvent.getBlock().getLocation()).tryAdvancedMatcher(path.switches.get("source_block"), path.context))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "block": {
                return this.location;
            }
            case "source_location": {
                return new LocationTag(this.blockEvent != null ? this.blockEvent.getBlock().getLocation() : this.entityEvent.getLocation());
            }
            case "source_entity": {
                return this.entityEvent == null ? null : new EntityTag(this.entityEvent.getEntity());
            }
            case "strength": {
                return new ElementTag(this.blockEvent != null ? this.blockEvent.getYield() : this.entityEvent.getYield());
            }
        }
        return super.getContext(name);
    }

    @Override
    public void cancellationChanged() {
        if (this.cancelled && this.rawList.contains(this.location.getBlock())) {
            this.rawList.remove(this.location.getBlock());
        } else if (!this.rawList.contains(this.location.getBlock())) {
            this.rawList.add(this.location.getBlock());
        }
    }

    @EventHandler
    public void onBlockExplodes(BlockExplodeEvent event) {
        this.blockEvent = event;
        this.entityEvent = null;
        this.rawList = event.blockList();
        for (Block block : new ArrayList<Block>(this.rawList)) {
            this.location = new LocationTag(block.getLocation());
            this.fire((Event)event);
        }
    }

    @EventHandler
    public void onEntityExplodes(EntityExplodeEvent event) {
        this.entityEvent = event;
        this.blockEvent = null;
        this.rawList = event.blockList();
        for (Block block : new ArrayList<Block>(this.rawList)) {
            this.location = new LocationTag(block.getLocation());
            this.fire((Event)event);
        }
    }
}

