/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.tags.core;

import com.denizenscript.denizen.objects.properties.bukkit.BukkitElementExtensions;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.core.EscapeTagUtil;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.ChatColor;

public class TextTagBase {
    public TextTagBase() {
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&amp", attribute -> {
            BukkitImplDeprecations.pointlessTextTags.warn(attribute.context);
            return new ElementTag("&");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&cm", attribute -> {
            BukkitImplDeprecations.pointlessTextTags.warn(attribute.context);
            return new ElementTag(",");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&sc", attribute -> {
            BukkitImplDeprecations.pointlessTextTags.warn(attribute.context);
            return new ElementTag(";");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&pipe", attribute -> {
            BukkitImplDeprecations.pointlessTextTags.warn(attribute.context);
            return new ElementTag("|");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&dot", attribute -> {
            BukkitImplDeprecations.pointlessTextTags.warn(attribute.context);
            return new ElementTag(".");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "p", attribute -> new ElementTag("\n " + String.valueOf(ChatColor.RESET) + " \n"));
        TagManager.registerTagHandler(ElementTag.class, "&hover", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String hoverText = attribute.getParam();
            String type = "SHOW_TEXT";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[hover=" + type + ";" + FormattedTextHelper.escape(hoverText) + "]");
        });
        TagManager.registerTagHandler(ElementTag.class, "&click", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String clickText = attribute.getParam();
            String type = "RUN_COMMAND";
            if (attribute.startsWith("type", 2)) {
                type = attribute.getContext(2);
                attribute.fulfill(1);
            }
            return new ElementTag("\u00a7[click=" + type + ";" + FormattedTextHelper.escape(clickText) + "]");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&insertion", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String insertText = attribute.getParam();
            return new ElementTag("\u00a7[insertion=" + FormattedTextHelper.escape(insertText) + "]");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&end_click", attribute -> new ElementTag("\u00a7[/click]"));
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&end_hover", attribute -> new ElementTag("\u00a7[/hover]"));
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&end_insertion", attribute -> new ElementTag("\u00a7[/insertion]"));
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&keybind", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String keybindText = attribute.getParam();
            return new ElementTag("\u00a7[keybind=" + FormattedTextHelper.escape(keybindText) + "]");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&selector", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            String selectorText = attribute.getParam();
            return new ElementTag("\u00a7[selector=" + FormattedTextHelper.escape(selectorText) + "]");
        });
        TagManager.registerTagHandler(ElementTag.class, ObjectTag.class, "&translate", (attribute, param) -> {
            MapTag translateMap = param.asType(MapTag.class, CoreUtilities.noDebugContext);
            if (translateMap == null) {
                BukkitImplDeprecations.translateLegacySyntax.warn(attribute.context);
                translateMap = new MapTag();
                translateMap.putObject("key", param);
                if (attribute.startsWith("with", 2)) {
                    translateMap.putObject("with", (ObjectTag)new ListTag(attribute.contextAsType(2, ListTag.class), with -> new ElementTag(EscapeTagUtil.unEscape(with), true)));
                    attribute.fulfill(1);
                }
            }
            return new ElementTag("\u00a7[translate=" + FormattedTextHelper.escape(translateMap.savable()) + "]", true);
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&score", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            ListTag scoreList = attribute.paramAsType(ListTag.class);
            if (scoreList.size() < 2) {
                return null;
            }
            String name = FormattedTextHelper.escape(EscapeTagUtil.unEscape(scoreList.get(0)));
            String objective = FormattedTextHelper.escape(EscapeTagUtil.unEscape(scoreList.get(1)));
            String value = scoreList.size() >= 3 ? FormattedTextHelper.escape(EscapeTagUtil.unEscape(scoreList.get(2))) : "";
            return new ElementTag("\u00a7[score=" + name + ";" + objective + ";" + value + "]");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&color", attribute -> {
            Object color;
            if (!attribute.hasParam()) {
                return null;
            }
            String colorName = attribute.getParam();
            String colorOut = null;
            if (colorName.length() == 1) {
                color = ChatColor.getByChar((char)colorName.charAt(0));
                if (color != null) {
                    colorOut = color.toString();
                }
            } else if (colorName.length() == 7 && colorName.startsWith("#")) {
                colorOut = FormattedTextHelper.stringifyRGBSpigot(colorName.substring(1));
            } else if (colorName.startsWith("co@") || colorName.lastIndexOf(44) > colorName.indexOf(44)) {
                color = ColorTag.valueOf(colorName, attribute.context);
                if (color == null && TagManager.isStaticParsing) {
                    return null;
                }
                String hex = Integer.toHexString(((ColorTag)color).asRGB());
                colorOut = FormattedTextHelper.stringifyRGBSpigot(hex);
            }
            if (colorOut == null) {
                try {
                    color = ChatColor.valueOf((String)CoreUtilities.toUpperCase(colorName));
                    colorOut = color.toString();
                }
                catch (IllegalArgumentException ex) {
                    attribute.echoError("Color '" + colorName + "' doesn't exist (for tag &color[...]).");
                    return null;
                }
            }
            return new ElementTag(colorOut);
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, MapTag.class, "&gradient", (attribute, inputMap) -> {
            ColorTag fromColor = inputMap.getRequiredObjectAs("from", ColorTag.class, attribute);
            ColorTag toColor = inputMap.getRequiredObjectAs("to", ColorTag.class, attribute);
            ElementTag style = inputMap.getElement("style", "RGB");
            if (fromColor == null || toColor == null) {
                return null;
            }
            if (!style.matchesEnum(BukkitElementExtensions.GradientStyle.class)) {
                attribute.echoError("Invalid gradient style '" + String.valueOf(style) + "'");
                return null;
            }
            return new ElementTag("\u00a7[gradient=" + String.valueOf(fromColor) + ";" + String.valueOf(toColor) + ";" + String.valueOf(style) + "]");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&font", attribute -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag("\u00a7[font=" + attribute.getParam() + "]");
        });
        TagManager.registerStaticTagBaseHandler(ElementTag.class, "&optimize", attribute -> new ElementTag("\u00a7[optimize=true]", true));
        for (ChatColor color : ChatColor.values()) {
            String nameVal = CoreUtilities.toLowerCase(color.name());
            String retVal = color.toString();
            TagManager.registerStaticTagBaseHandler(ElementTag.class, nameVal, attribute -> new ElementTag(retVal));
            TagManager.registerStaticTagBaseHandler(ElementTag.class, "&" + color.getChar(), attribute -> new ElementTag(retVal));
        }
    }
}

