/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.npc.traits;

import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.scripts.containers.core.AssignmentScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.event.EventHandler;

public class ConstantsTrait
extends Trait {
    @Persist(value="", collectionType=HashMap.class)
    private Map<String, String> constants = new HashMap<String, String>();
    private Map<String, String> assignmentConstants = new HashMap<String, String>();

    public ConstantsTrait() {
        super("constants");
    }

    public String getConstant(String name) {
        if (this.constants.containsKey(CoreUtilities.toLowerCase(name))) {
            return TagManager.tag(this.constants.get(CoreUtilities.toLowerCase(name)), new BukkitTagContext(null, new NPCTag(this.npc), null, true, null));
        }
        if (this.assignmentConstants.containsKey(CoreUtilities.toLowerCase(name))) {
            return TagManager.tag(this.assignmentConstants.get(CoreUtilities.toLowerCase(name)), new BukkitTagContext(null, new NPCTag(this.npc), null, true, null));
        }
        return null;
    }

    public void setConstant(String name, String value) {
        this.constants.put(CoreUtilities.toLowerCase(name), value);
    }

    public void removeConstant(String name) {
        this.constants.remove(CoreUtilities.toLowerCase(name));
    }

    public void rebuildAssignmentConstants() {
        this.assignmentConstants.clear();
        if (!this.npc.hasTrait(AssignmentTrait.class)) {
            this.npc.removeTrait(ConstantsTrait.class);
            return;
        }
        AssignmentTrait trait = (AssignmentTrait)this.npc.getOrAddTrait(AssignmentTrait.class);
        for (AssignmentScriptContainer container : trait.containerCache) {
            if (container == null || !container.contains("default constants", Map.class)) continue;
            for (StringHolder constant : container.getConfigurationSection("default constants").getKeys(false)) {
                this.assignmentConstants.put(CoreUtilities.toLowerCase(constant.str), container.getString("default constants." + constant.str.toUpperCase(), ""));
            }
        }
    }

    @EventHandler
    public void onScriptsReload(ScriptReloadEvent event) {
        this.rebuildAssignmentConstants();
    }
}

