/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.objects.core;

import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.QuaternionTag;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.CoreUtilities;

public interface VectorObject
extends ObjectTag {
    @Override
    public VectorObject duplicate();

    public double getX();

    public double getY();

    public double getZ();

    public void setX(double var1);

    public void setY(double var1);

    public void setZ(double var1);

    default public double lengthSquared() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return x * x + y * y + z * z;
    }

    default public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    default public double dot(VectorObject other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    default public VectorObject crossProduct(VectorObject other) {
        VectorObject obj = this.duplicate();
        obj.setX(this.getY() * other.getZ() - other.getY() * this.getZ());
        obj.setY(other.getX() * this.getZ() - this.getX() * other.getZ());
        obj.setZ(this.getX() * other.getY() - this.getY() * other.getX());
        return obj;
    }

    default public VectorObject multipliedBy(double scale) {
        VectorObject obj = this.duplicate();
        obj.setX(this.getX() * scale);
        obj.setY(this.getY() * scale);
        obj.setZ(this.getZ() * scale);
        return obj;
    }

    default public VectorObject project(VectorObject other) {
        return other.multipliedBy(this.dot(other) / other.lengthSquared());
    }

    public static <T extends VectorObject> void register(Class<T> type, ObjectTagProcessor<T> processor) {
        processor.registerTag(ElementTag.class, "x", (attribute, object) -> new ElementTag(object.getX()), new String[0]);
        processor.registerTag(ElementTag.class, "y", (attribute, object) -> new ElementTag(object.getY()), new String[0]);
        processor.registerTag(ElementTag.class, "z", (attribute, object) -> new ElementTag(object.getZ()), new String[0]);
        processor.registerTag(ElementTag.class, "xyz", (attribute, object) -> new ElementTag(CoreUtilities.doubleToString(object.getX()) + "," + CoreUtilities.doubleToString(object.getY()) + "," + CoreUtilities.doubleToString(object.getZ())), new String[0]);
        processor.registerTag(type, "with_x", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            VectorObject output = object.duplicate();
            output.setX(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        processor.registerTag(type, "with_y", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            VectorObject output = object.duplicate();
            output.setY(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        processor.registerTag(type, "with_z", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            VectorObject output = object.duplicate();
            output.setZ(attribute.getDoubleParam());
            return output;
        }, new String[0]);
        processor.registerTag(type, type, "add", (attribute, object, input) -> {
            VectorObject other = object.duplicate();
            other.setX(object.getX() + input.getX());
            other.setY(object.getY() + input.getY());
            other.setZ(object.getZ() + input.getZ());
            return other;
        }, new String[0]);
        processor.registerTag(type, type, "sub", (attribute, object, input) -> {
            VectorObject other = object.duplicate();
            other.setX(object.getX() - input.getX());
            other.setY(object.getY() - input.getY());
            other.setZ(object.getZ() - input.getZ());
            return other;
        }, new String[0]);
        processor.registerTag(type, ElementTag.class, "mul", (attribute, object, length) -> object.multipliedBy(length.asDouble()), new String[0]);
        processor.registerTag(type, ElementTag.class, "div", (attribute, object, length) -> {
            VectorObject other = object.duplicate();
            double len = 1.0 / length.asDouble();
            other.setX(object.getX() * len);
            other.setY(object.getY() * len);
            other.setZ(object.getZ() * len);
            return other;
        }, new String[0]);
        processor.registerTag(type, "normalize", (attribute, object) -> {
            double len = object.length();
            if (len == 0.0) {
                len = 1.0;
            }
            len = 1.0 / len;
            VectorObject other = object.duplicate();
            other.setX(object.getX() * len);
            other.setY(object.getY() * len);
            other.setZ(object.getZ() * len);
            return other;
        }, new String[0]);
        processor.registerTag(ElementTag.class, "vector_length_squared", (attribute, object) -> new ElementTag(object.lengthSquared()), new String[0]);
        processor.registerTag(ElementTag.class, "vector_length", (attribute, object) -> new ElementTag(object.length()), new String[0]);
        processor.registerTag(QuaternionTag.class, ElementTag.class, "to_axis_angle_quaternion", (attribute, object, angle) -> {
            double a = angle.asDouble();
            double s = Math.sin(a * 0.5);
            return new QuaternionTag(object.getX() * s, object.getY() * s, object.getZ() * s, Math.cos(a * 0.5));
        }, new String[0]);
        processor.registerTag(QuaternionTag.class, type, "quaternion_between_vectors", (attribute, object, other) -> {
            double dot = object.dot((VectorObject)other);
            if (dot < (double)-0.9999f) {
                double absX = Math.abs(object.getX());
                double absY = Math.abs(object.getY());
                double absZ = Math.abs(object.getZ());
                if (absX < absY && absX < absZ) {
                    return new QuaternionTag(0.0, -object.getZ(), object.getY(), 0.0).normalized();
                }
                if (absY < absZ) {
                    return new QuaternionTag(-object.getZ(), 0.0, object.getX(), 0.0).normalized();
                }
                return new QuaternionTag(-object.getY(), object.getX(), 0.0, 0.0).normalized();
            }
            VectorObject axis = object.crossProduct((VectorObject)other);
            return new QuaternionTag(axis.getX(), axis.getY(), axis.getZ(), dot + 1.0).normalized();
        }, new String[0]);
    }
}

