/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Slime;

public class EntitySize
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && (((EntityTag)entity).getBukkitEntity() instanceof Slime || ((EntityTag)entity).getBukkitEntity() instanceof Phantom || ((EntityTag)entity).getBukkitEntity() instanceof PufferFish);
    }

    public static EntitySize getFrom(ObjectTag entity) {
        if (!EntitySize.describes(entity)) {
            return null;
        }
        return new EntitySize((EntityTag)entity);
    }

    public EntitySize(EntityTag ent) {
        this.entity = ent;
    }

    public int getSize() {
        if (this.isSlime()) {
            return this.getSlime().getSize();
        }
        if (this.isPhantom()) {
            return this.getPhantom().getSize();
        }
        return this.getPufferFish().getPuffState();
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getSize());
    }

    @Override
    public String getPropertyId() {
        return "size";
    }

    public static void register() {
        PropertyParser.registerTag(EntitySize.class, ElementTag.class, "size", (attribute, object) -> new ElementTag(object.getSize()), new String[0]);
        PropertyParser.registerMechanism(EntitySize.class, ElementTag.class, "size", (object, mechanism, input) -> {
            if (mechanism.requireInteger()) {
                if (object.isSlime()) {
                    object.getSlime().setSize(input.asInt());
                } else if (object.isPhantom()) {
                    object.getPhantom().setSize(input.asInt());
                } else {
                    object.getPufferFish().setPuffState(input.asInt());
                }
            }
        }, new String[0]);
    }

    public boolean isSlime() {
        return this.entity.getBukkitEntity() instanceof Slime;
    }

    public boolean isPhantom() {
        return this.entity.getBukkitEntity() instanceof Phantom;
    }

    public Slime getSlime() {
        return (Slime)this.entity.getBukkitEntity();
    }

    public Phantom getPhantom() {
        return (Phantom)this.entity.getBukkitEntity();
    }

    public PufferFish getPufferFish() {
        return (PufferFish)this.entity.getBukkitEntity();
    }
}

