/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers;

import com.denizenscript.denizen.events.player.PlayerReceivesPacketScriptEvent;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenPacketListenerImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.ActionBarEventPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.AttachPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.BlockLightPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.DenizenPacketHandlerPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.DisguisePacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.EntityMetadataPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.FakeBlocksPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.FakeEquipmentPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.FakePlayerPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.HiddenEntitiesPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.HideParticlesPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.PlayerHearsSoundEventPacketHandlers;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet.TablistUpdateEventPacketHandlers;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptCodeGen;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class DenizenNetworkManagerImpl
extends NetworkManager {
    public static final Map<Class<? extends Packet<PacketListenerPlayOut>>, List<PacketHandler<?>>> packetHandlers = new HashMap();
    public final NetworkManager oldManager;
    public final DenizenPacketListenerImpl packetListener;
    public final EntityPlayer player;
    public int packetsSent;
    public int packetsReceived;
    private static final Field protocolDirectionField;
    public static final Field Connection_packetListener;
    private static final Field ServerGamePacketListener_ConnectionField;
    private static final MethodHandle ServerGamePacketListener_ConnectionSetter;

    public static <T extends Packet<?>> T copyPacket(T original, StreamCodec<? super RegistryFriendlyByteBuf, T> packetCodec) {
        try {
            RegistryFriendlyByteBuf copier = new RegistryFriendlyByteBuf(Unpooled.buffer(), CraftRegistry.getMinecraftRegistry());
            packetCodec.encode((Object)copier, original);
            return (T)((Packet)packetCodec.decode((Object)copier));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public static <T extends Packet<PacketListenerPlayOut>> void registerPacketHandler(Class<T> packetClass, PacketHandler<T> handler) {
        packetHandlers.computeIfAbsent(packetClass, k -> new ArrayList()).add(handler);
    }

    public static <T extends Packet<PacketListenerPlayOut>> void registerPacketHandler(Class<T> packetClass, BiConsumer<DenizenNetworkManagerImpl, T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetClass, (DenizenNetworkManagerImpl networkManager, T packet) -> {
            handler.accept(networkManager, packet);
            return packet;
        });
    }

    public DenizenNetworkManagerImpl(EntityPlayer entityPlayer, NetworkManager oldManager) {
        super(DenizenNetworkManagerImpl.getProtocolDirection(oldManager));
        this.oldManager = oldManager;
        this.n = oldManager.n;
        this.player = entityPlayer;
        this.packetListener = (DenizenPacketListenerImpl)((Object)NetworkInterceptCodeGen.generateAppropriateInterceptor((Object)((Object)this), (Object)entityPlayer, DenizenPacketListenerImpl.class, AbstractListenerPlayInImpl.class, PlayerConnection.class));
        if (!(oldManager.k() instanceof ServerConfigurationPacketListener)) {
            this.setListener((PacketListener)this.packetListener);
        }
    }

    public void setListener(PacketListener listener) {
        try {
            Connection_packetListener.set(this.oldManager, listener);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            throw new RuntimeException("Failed to set packet listener due to reflection error", e);
        }
    }

    public static NetworkManager getConnection(EntityPlayer player) {
        try {
            return (NetworkManager)ServerGamePacketListener_ConnectionField.get(player.c);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            throw new RuntimeException("Failed to get connection from player due to reflection error", ex);
        }
    }

    public static NetworkManager getConnection(Player player) {
        return DenizenNetworkManagerImpl.getConnection(((CraftPlayer)player).getHandle());
    }

    public static DenizenNetworkManagerImpl getNetworkManager(EntityPlayer player) {
        return (DenizenNetworkManagerImpl)DenizenNetworkManagerImpl.getConnection(player);
    }

    public static DenizenNetworkManagerImpl getNetworkManager(Player player) {
        return DenizenNetworkManagerImpl.getNetworkManager(((CraftPlayer)player).getHandle());
    }

    public static void setNetworkManager(Player player) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        PlayerConnection playerConnection = entityPlayer.c;
        DenizenNetworkManagerImpl.setNetworkManager(playerConnection, new DenizenNetworkManagerImpl(entityPlayer, DenizenNetworkManagerImpl.getConnection(entityPlayer)));
    }

    public static void enableNetworkManager() {
        for (World w : Bukkit.getWorlds()) {
            for (PlayerChunkMap.EntityTracker tracker : ((CraftWorld)w).getHandle().l().a.J.values()) {
                ArrayList connections = new ArrayList(tracker.f);
                tracker.f.clear();
                for (ServerPlayerConnection connection : connections) {
                    tracker.f.add(connection.o().c);
                }
            }
        }
    }

    public int hashCode() {
        return this.oldManager.hashCode();
    }

    public boolean equals(Object c2) {
        return this.oldManager.equals(c2);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelRegistered(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelUnregistered(ctx);
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        this.oldManager.channelActive(channelhandlercontext);
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.oldManager.channelInactive(channelhandlercontext);
    }

    public boolean isSharable() {
        return this.oldManager.isSharable();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        this.oldManager.exceptionCaught(channelhandlercontext, throwable);
    }

    protected void a(ChannelHandlerContext channelhandlercontext, Packet packet) {
        if (this.oldManager.n.isOpen()) {
            try {
                packet.a((PacketListener)this.packetListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void a(PacketListener packetlistener) {
        this.oldManager.a(packetlistener);
    }

    public void a(String s, int i, PacketStatusOutListener packetstatusoutlistener) {
        this.oldManager.a(s, i, packetstatusoutlistener);
    }

    public void a(String s, int i, PacketLoginOutListener packetloginoutlistener) {
        this.oldManager.a(s, i, packetloginoutlistener);
    }

    public void a(Packet<?> packet) {
        this.a(packet, null);
    }

    public static void doPacketOutput(String text) {
        if (!NMSHandler.debugPackets) {
            return;
        }
        if (NMSHandler.debugPacketFilter == null || NMSHandler.debugPacketFilter.trim().isEmpty() || CoreUtilities.toLowerCase((String)text).contains(NMSHandler.debugPacketFilter)) {
            Debug.log((String)text);
        }
    }

    public void debugOutputPacket(Packet<?> packet) {
        if (packet instanceof PacketPlayOutEntityMetadata) {
            StringBuilder output = new StringBuilder(128);
            output.append("Packet: ClientboundSetEntityDataPacket sent to ").append(this.player.cB()).append(" for entity ID: ").append(((PacketPlayOutEntityMetadata)packet).b()).append(": ");
            List list = ((PacketPlayOutEntityMetadata)packet).e();
            if (list == null) {
                output.append("None");
            } else {
                for (DataWatcher.c data : list) {
                    output.append('[').append(data.a()).append(": ").append(data.c()).append("], ");
                }
            }
            DenizenNetworkManagerImpl.doPacketOutput(output.toString());
        } else if (packet instanceof PacketPlayOutEntityVelocity) {
            PacketPlayOutEntityVelocity velPacket = (PacketPlayOutEntityVelocity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundSetEntityMotionPacket sent to " + this.player.cB() + " for entity ID: " + velPacket.b() + ": " + velPacket.e() + "," + velPacket.f() + "," + velPacket.g());
        } else if (packet instanceof PacketPlayOutSpawnEntity) {
            PacketPlayOutSpawnEntity addEntityPacket = (PacketPlayOutSpawnEntity)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundAddEntityPacket sent to " + this.player.cB() + " for entity ID: " + addEntityPacket.b() + ": uuid: " + String.valueOf(addEntityPacket.e()) + ", type: " + String.valueOf(addEntityPacket.f()) + ", at: " + addEntityPacket.g() + "," + addEntityPacket.h() + "," + addEntityPacket.i() + ", data: " + addEntityPacket.p());
        } else if (packet instanceof PacketPlayOutMap) {
            PacketPlayOutMap mapPacket = (PacketPlayOutMap)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundMapItemDataPacket sent to " + this.player.cB() + " for map ID: " + String.valueOf(mapPacket.b()) + ", scale: " + mapPacket.e() + ", locked: " + mapPacket.f());
        } else if (packet instanceof PacketPlayOutEntityDestroy) {
            PacketPlayOutEntityDestroy removePacket = (PacketPlayOutEntityDestroy)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundRemoveEntitiesPacket sent to " + this.player.cB() + " for entities: " + removePacket.b().stream().map(Object::toString).collect(Collectors.joining(", ")));
        } else if (packet instanceof ClientboundPlayerInfoUpdatePacket) {
            ClientboundPlayerInfoUpdatePacket playerInfoPacket = (ClientboundPlayerInfoUpdatePacket)packet;
            DenizenNetworkManagerImpl.doPacketOutput("Packet: ClientboundPlayerInfoPacket sent to " + this.player.cB() + " of types " + String.valueOf(playerInfoPacket.b()) + " for player profiles: " + playerInfoPacket.e().stream().map(p -> "mode=" + String.valueOf(p.e()) + "/latency=" + p.d() + "/display=" + String.valueOf(p.f()) + "/name=" + p.b().getName() + "/id=" + String.valueOf(p.b().getId()) + "/" + p.b().getProperties().asMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + ((Collection)e.getValue()).stream().map(v -> v.value() + ";" + v.signature()).collect(Collectors.joining(";;;"))).collect(Collectors.joining("/"))).collect(Collectors.joining(", ")));
        } else {
            DenizenNetworkManagerImpl.doPacketOutput("Packet: " + packet.getClass().getCanonicalName() + " sent to " + this.player.cB());
        }
    }

    public void a(Packet<?> packet, PacketSendListener genericfuturelistener) {
        this.a(packet, genericfuturelistener, true);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener genericfuturelistener, boolean flush) {
        if (!Bukkit.isPrimaryThread()) {
            if (Settings.cache_warnOnAsyncPackets && !(packet instanceof ClientboundSystemChatPacket) && !(packet instanceof ClientboundPlayerChatPacket) && !(packet instanceof PacketPlayOutTabComplete)) {
                Debug.echoError((String)("Warning: packet sent off main thread! This is completely unsupported behavior! Denizen network interceptor ignoring packet to avoid crash. Packet class: " + packet.getClass().getCanonicalName() + " sent to " + this.player.cB() + " identify the sender of the packet from the stack trace:"));
                try {
                    throw new RuntimeException("Trace");
                }
                catch (Exception ex) {
                    Debug.echoError((Throwable)ex);
                }
            }
            this.oldManager.a(packet, genericfuturelistener, flush);
            return;
        }
        if (NMSHandler.debugPackets) {
            this.debugOutputPacket((Packet<?>)packet);
        }
        ++this.packetsSent;
        if (packet instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = packet;
            ArrayList<Packet<PacketListenerPlayOut>> processedPackets = new ArrayList<Packet<PacketListenerPlayOut>>();
            boolean anyChange = false;
            Iterator iterator = bundlePacket.b().iterator();
            while (iterator.hasNext()) {
                Packet _subPacket;
                Packet subPacket = _subPacket = (Packet)iterator.next();
                Packet<PacketListenerPlayOut> processed = this.processPacketHandlersFor((Packet<PacketListenerPlayOut>)subPacket);
                boolean bl = anyChange = anyChange || processed != subPacket;
                if (processed == null) continue;
                processedPackets.add(processed);
            }
            if (processedPackets.isEmpty()) {
                return;
            }
            if (anyChange) {
                packet = new ClientboundBundlePacket(processedPackets);
            }
        } else {
            Packet<PacketListenerPlayOut> processed = this.processPacketHandlersFor((Packet<PacketListenerPlayOut>)packet);
            if (processed == null) {
                return;
            }
            packet = processed;
        }
        this.oldManager.a(packet, genericfuturelistener, flush);
    }

    public void a(Consumer<NetworkManager> consumer) {
        this.oldManager.a(consumer);
    }

    public void a() {
        this.oldManager.a();
    }

    public Packet<PacketListenerPlayOut> processPacketHandlersFor(Packet<PacketListenerPlayOut> packet) {
        if (packet == null) {
            return null;
        }
        List<PacketHandler<?>> packetHandlers = DenizenNetworkManagerImpl.packetHandlers.get(packet.getClass());
        if (packetHandlers != null) {
            Iterator<PacketHandler<?>> iterator = packetHandlers.iterator();
            while (iterator.hasNext()) {
                Packet<PacketListenerPlayOut> processed;
                PacketHandler<?> _packetHandler;
                PacketHandler<?> packetHandler = _packetHandler = iterator.next();
                try {
                    processed = packetHandler.handlePacket(this, packet);
                }
                catch (Exception ex) {
                    Debug.echoError((String)("Packet handler for " + packet.getClass().getCanonicalName() + " threw an exception:"));
                    Debug.echoError((Throwable)ex);
                    continue;
                }
                if (processed == null) {
                    if (NMSHandler.debugPackets) {
                        DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET - " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.cB());
                    }
                    return null;
                }
                packet = processed;
            }
        }
        if (PlayerReceivesPacketScriptEvent.instance.eventData.isEnabled & PlayerReceivesPacketScriptEvent.fireFor((Player)this.player.getBukkitEntity(), packet)) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DENIED PACKET - " + packet.getClass().getCanonicalName() + " DENIED FROM SEND TO " + this.player.cB() + " due to event");
            }
            return null;
        }
        return packet;
    }

    public void b() {
        this.oldManager.b();
    }

    public SocketAddress d() {
        return this.oldManager.d();
    }

    public String a(boolean flag) {
        return this.oldManager.a(flag);
    }

    public void a(IChatBaseComponent ichatbasecomponent) {
        if (!this.player.getBukkitEntity().isOnline()) {
            return;
        }
        this.oldManager.a(ichatbasecomponent);
    }

    public boolean e() {
        return this.oldManager != null && this.oldManager.e();
    }

    public EnumProtocolDirection f() {
        return this.oldManager.f();
    }

    public EnumProtocolDirection g() {
        return this.oldManager.g();
    }

    public void a(ChannelPipeline channelpipeline) {
        this.oldManager.a(channelpipeline);
    }

    public void a(Cipher cipher, Cipher cipher1) {
        this.oldManager.a(cipher, cipher1);
    }

    public boolean h() {
        return this.oldManager.h();
    }

    public boolean i() {
        return this.oldManager.i();
    }

    public boolean j() {
        return this.oldManager.j();
    }

    public PacketListener k() {
        return this.oldManager.k();
    }

    public IChatBaseComponent l() {
        return this.oldManager.l();
    }

    public void m() {
        this.oldManager.m();
    }

    public void a(int i, boolean b2) {
        this.oldManager.a(i, b2);
    }

    public void n() {
        this.oldManager.n();
    }

    public float o() {
        return this.oldManager.o();
    }

    public float p() {
        return this.oldManager.p();
    }

    private static EnumProtocolDirection getProtocolDirection(NetworkManager networkManager) {
        EnumProtocolDirection direction = null;
        try {
            direction = (EnumProtocolDirection)protocolDirectionField.get(networkManager);
        }
        catch (Exception e) {
            Debug.echoError((Throwable)e);
        }
        return direction;
    }

    private static void setNetworkManager(PlayerConnection playerConnection, NetworkManager networkManager) {
        try {
            ServerGamePacketListener_ConnectionSetter.invoke(playerConnection, networkManager);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean acceptInboundMessage(Object msg) throws Exception {
        return this.oldManager.acceptInboundMessage(msg);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.oldManager.channelRead(ctx, msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelReadComplete(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.oldManager.userEventTriggered(ctx, evt);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.oldManager.channelWritabilityChanged(ctx);
    }

    static {
        ActionBarEventPacketHandlers.registerHandlers();
        AttachPacketHandlers.registerHandlers();
        BlockLightPacketHandlers.registerHandlers();
        DenizenPacketHandlerPacketHandlers.registerHandlers();
        EntityMetadataPacketHandlers.registerHandlers();
        DisguisePacketHandlers.registerHandlers();
        FakeBlocksPacketHandlers.registerHandlers();
        FakeEquipmentPacketHandlers.registerHandlers();
        FakePlayerPacketHandlers.registerHandlers();
        HiddenEntitiesPacketHandlers.registerHandlers();
        HideParticlesPacketHandlers.registerHandlers();
        PlayerHearsSoundEventPacketHandlers.registerHandlers();
        ProfileEditorImpl.registerHandlers();
        TablistUpdateEventPacketHandlers.registerHandlers();
        protocolDirectionField = ReflectionHelper.getFields(NetworkManager.class).get(ReflectionMappingsInfo.Connection_receiving, EnumProtocolDirection.class);
        Connection_packetListener = ReflectionHelper.getFields(NetworkManager.class).get(ReflectionMappingsInfo.Connection_packetListener, PacketListener.class);
        ServerGamePacketListener_ConnectionField = ReflectionHelper.getFields(ServerCommonPacketListenerImpl.class).get(ReflectionMappingsInfo.ServerCommonPacketListenerImpl_connection);
        ServerGamePacketListener_ConnectionSetter = ReflectionHelper.getFinalSetter(ServerCommonPacketListenerImpl.class, (String)ReflectionMappingsInfo.ServerCommonPacketListenerImpl_connection);
    }

    @FunctionalInterface
    public static interface PacketHandler<T extends Packet<PacketListenerPlayOut>> {
        public Packet<PacketListenerPlayOut> handlePacket(DenizenNetworkManagerImpl var1, T var2) throws Exception;
    }
}

