/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.destroystokyo.paper.event.player.PlayerAdvancementCriterionGrantEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerGrantedAdvancementCriterionScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ElementTag criterion;
    public ElementTag advancement;
    public PlayerAdvancementCriterionGrantEvent event;

    public PlayerGrantedAdvancementCriterionScriptEvent() {
        this.registerCouldMatcher("player granted advancement criterion");
        this.registerSwitches("advancement", "criterion");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryObjectSwitch("advancement", this.advancement)) {
            return false;
        }
        if (!path.tryObjectSwitch("criterion", this.criterion)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "criterion" -> this.criterion;
            case "advancement" -> this.advancement;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void playerGrantedAdvancementCriterionEvent(PlayerAdvancementCriterionGrantEvent event) {
        this.event = event;
        this.criterion = new ElementTag(Utilities.namespacedKeyToString(Utilities.parseNamespacedKey(event.getCriterion())));
        this.advancement = new ElementTag(Utilities.namespacedKeyToString(event.getAdvancement().getKey()));
        this.fire((Event)event);
    }
}

