/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.player;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;

public class OxygenCommand
extends AbstractCommand {
    public OxygenCommand() {
        this.setName("oxygen");
        this.setSyntax("oxygen [<#>] (type:{remaining}/maximum) (mode:{set}/add/remove)");
        this.setRequiredArguments(1, 3);
        this.isProcedural = false;
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("type") && arg.matchesPrefix("type", "t") && arg.matchesEnum(Type.class)) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("mode") && arg.matchesPrefix("mode", "m") && arg.matchesEnum(Mode.class)) {
                scriptEntry.addObject("mode", arg.asElement());
                continue;
            }
            if (scriptEntry.hasObject("amount") || !arg.matchesInteger()) continue;
            scriptEntry.addObject("amount", arg.asElement());
        }
        if (!Utilities.entryHasPlayer(scriptEntry) || !Utilities.getEntryPlayer(scriptEntry).isValid()) {
            throw new InvalidArgumentsException("Must have player context!");
        }
        if (!scriptEntry.hasObject("amount")) {
            throw new InvalidArgumentsException("Must specify a valid amount!");
        }
        scriptEntry.defaultObject("type", new ElementTag("REMAINING")).defaultObject("mode", new ElementTag("SET"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        ElementTag type = scriptEntry.getElement("type");
        ElementTag mode = scriptEntry.getElement("mode");
        ElementTag amount = scriptEntry.getElement("amount");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), type, mode, amount);
        }
        PlayerTag player = Utilities.getEntryPlayer(scriptEntry);
        block0 : switch (Type.valueOf(type.asString().toUpperCase()).ordinal()) {
            case 0: {
                switch (Mode.valueOf(mode.asString().toUpperCase()).ordinal()) {
                    case 0: {
                        player.setMaximumAir(amount.asInt());
                        break;
                    }
                    case 1: {
                        player.setMaximumAir(player.getMaximumAir() + amount.asInt());
                        break;
                    }
                    case 2: {
                        player.setMaximumAir(player.getMaximumAir() - amount.asInt());
                    }
                }
                break;
            }
            case 1: {
                switch (Mode.valueOf(mode.asString().toUpperCase()).ordinal()) {
                    case 0: {
                        player.setRemainingAir(amount.asInt());
                        break block0;
                    }
                    case 1: {
                        player.setRemainingAir(player.getRemainingAir() + amount.asInt());
                        break block0;
                    }
                    case 2: {
                        player.setRemainingAir(player.getRemainingAir() - amount.asInt());
                    }
                }
            }
        }
    }

    public static enum Type {
        MAXIMUM,
        REMAINING;

    }

    public static enum Mode {
        SET,
        ADD,
        REMOVE;

    }
}

