/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;

public class NBTAdapter {
    public static final MethodHandle COMPOUND_TAG_MAP_CONSTRUCTOR = ReflectionHelper.getConstructor(up.class, (Class[])new Class[]{Map.class});

    public static vp toNMS(BinaryTag tag) {
        if (tag instanceof ByteBinaryTag) {
            ByteBinaryTag byteTag = (ByteBinaryTag)tag;
            return switch (byteTag.value()) {
                case 0 -> un.b;
                case 1 -> un.c;
                default -> un.a((byte)byteTag.value());
            };
        }
        if (tag instanceof ShortBinaryTag) {
            ShortBinaryTag shortTag = (ShortBinaryTag)tag;
            return vi.a((short)shortTag.value());
        }
        if (tag instanceof IntBinaryTag) {
            IntBinaryTag intTag = (IntBinaryTag)tag;
            return uu.a((int)intTag.value());
        }
        if (tag instanceof LongBinaryTag) {
            LongBinaryTag longTag = (LongBinaryTag)tag;
            return ux.a((long)longTag.value());
        }
        if (tag instanceof FloatBinaryTag) {
            FloatBinaryTag floatTag = (FloatBinaryTag)tag;
            return us.a((float)floatTag.value());
        }
        if (tag instanceof DoubleBinaryTag) {
            DoubleBinaryTag doubleTag = (DoubleBinaryTag)tag;
            return uq.a((double)doubleTag.value());
        }
        if (tag instanceof ByteArrayBinaryTag) {
            ByteArrayBinaryTag byteArrayTag = (ByteArrayBinaryTag)tag;
            return new um(byteArrayTag.value());
        }
        if (tag instanceof IntArrayBinaryTag) {
            IntArrayBinaryTag intArrayTag = (IntArrayBinaryTag)tag;
            return new ut(intArrayTag.value());
        }
        if (tag instanceof LongArrayBinaryTag) {
            LongArrayBinaryTag longArrayTag = (LongArrayBinaryTag)tag;
            return new uw(longArrayTag.value());
        }
        if (tag instanceof StringBinaryTag) {
            StringBinaryTag stringTag = (StringBinaryTag)tag;
            return vn.a((String)stringTag.value());
        }
        if (tag instanceof ListBinaryTag) {
            ListBinaryTag listTag = (ListBinaryTag)tag;
            return NBTAdapter.toNMS(listTag);
        }
        if (tag instanceof CompoundBinaryTag) {
            CompoundBinaryTag compoundTag = (CompoundBinaryTag)tag;
            return NBTAdapter.toNMS(compoundTag);
        }
        if (tag instanceof EndBinaryTag) {
            return ur.b;
        }
        throw new IllegalStateException("Unrecognized API tag of type '" + String.valueOf(tag.type()) + "': " + String.valueOf(tag));
    }

    public static BinaryTag toAPI(vp nmsTag) {
        if (nmsTag instanceof un) {
            un nmsByteTag = (un)nmsTag;
            return ByteBinaryTag.byteBinaryTag((byte)nmsByteTag.n());
        }
        if (nmsTag instanceof vi) {
            vi nmsShortTag = (vi)nmsTag;
            return ShortBinaryTag.shortBinaryTag((short)nmsShortTag.n());
        }
        if (nmsTag instanceof uu) {
            uu nmsIntTag = (uu)nmsTag;
            return IntBinaryTag.intBinaryTag((int)nmsIntTag.n());
        }
        if (nmsTag instanceof ux) {
            ux nmsLongTag = (ux)nmsTag;
            return LongBinaryTag.longBinaryTag((long)nmsLongTag.n());
        }
        if (nmsTag instanceof us) {
            us nmsFloatTag = (us)nmsTag;
            return FloatBinaryTag.floatBinaryTag((float)nmsFloatTag.n());
        }
        if (nmsTag instanceof uq) {
            uq nmsDoubleTag = (uq)nmsTag;
            return DoubleBinaryTag.doubleBinaryTag((double)nmsDoubleTag.n());
        }
        if (nmsTag instanceof um) {
            um nmsByteArrayTag = (um)nmsTag;
            return ByteArrayBinaryTag.byteArrayBinaryTag((byte[])nmsByteArrayTag.e());
        }
        if (nmsTag instanceof ut) {
            ut nmsIntArrayTag = (ut)nmsTag;
            return IntArrayBinaryTag.intArrayBinaryTag((int[])nmsIntArrayTag.g());
        }
        if (nmsTag instanceof uw) {
            uw nmsLongArrayTag = (uw)nmsTag;
            return LongArrayBinaryTag.longArrayBinaryTag((long[])nmsLongArrayTag.g());
        }
        if (nmsTag instanceof vn) {
            vn nmsStringTag = (vn)nmsTag;
            return StringBinaryTag.stringBinaryTag((String)nmsStringTag.k());
        }
        if (nmsTag instanceof uv) {
            uv nmsListTag = (uv)nmsTag;
            return NBTAdapter.toAPI(nmsListTag);
        }
        if (nmsTag instanceof up) {
            up nmsCompoundTag = (up)nmsTag;
            return NBTAdapter.toAPI(nmsCompoundTag);
        }
        if (nmsTag instanceof ur) {
            return EndBinaryTag.endBinaryTag();
        }
        throw new IllegalStateException("Unrecognized NMS tag of type '" + nmsTag.getClass().getName() + "/" + nmsTag.c().a() + "': " + String.valueOf(nmsTag));
    }

    public static ListBinaryTag toAPI(uv nmsListTag) {
        ArrayList<BinaryTag> tags = new ArrayList<BinaryTag>(nmsListTag.size());
        for (vp nmsValue : nmsListTag) {
            tags.add(NBTAdapter.toAPI(nmsValue));
        }
        return ListBinaryTag.listBinaryTag((BinaryTagType)BinaryTagTypes.LIST_WILDCARD, tags);
    }

    public static uv toNMS(ListBinaryTag listTag) {
        ArrayList<vp> nmsTags = new ArrayList<vp>(listTag.size());
        for (BinaryTag value : listTag) {
            nmsTags.add(NBTAdapter.toNMS(value));
        }
        return new uv(nmsTags);
    }

    public static CompoundBinaryTag toAPI(up nmsCompoundTag) {
        HashMap<String, BinaryTag> tags = new HashMap<String, BinaryTag>(nmsCompoundTag.i());
        for (Map.Entry nmsEntry : nmsCompoundTag.g()) {
            tags.put((String)nmsEntry.getKey(), NBTAdapter.toAPI((vp)nmsEntry.getValue()));
        }
        return CompoundBinaryTag.from(tags);
    }

    public static up toNMS(CompoundBinaryTag compoundTag) {
        HashMap<String, vp> nmsTags = new HashMap<String, vp>(compoundTag.size());
        for (Map.Entry entry : compoundTag) {
            nmsTags.put((String)entry.getKey(), NBTAdapter.toNMS((BinaryTag)entry.getValue()));
        }
        try {
            return COMPOUND_TAG_MAP_CONSTRUCTOR.invokeExact(nmsTags);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2);
        }
    }
}

