/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.BukkitImplDeprecations;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import java.util.UUID;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemSkullskin
implements Property {
    public static final String[] handledTags = new String[]{"skin", "has_skin", "skull_skin"};
    public static final String[] handledMechs = new String[]{"skull_skin"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getItemMeta() instanceof SkullMeta;
    }

    public static ItemSkullskin getFrom(ObjectTag _item) {
        if (!ItemSkullskin.describes(_item)) {
            return null;
        }
        return new ItemSkullskin((ItemTag)_item);
    }

    public ItemSkullskin(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("skull_skin")) {
            String skin = this.getPropertyString();
            if (skin == null) {
                return null;
            }
            return new ElementTag(skin).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("skin")) {
            String skin = this.getPropertyString();
            if (skin != null) {
                if ((attribute = attribute.fulfill(1)).startsWith("full")) {
                    BukkitImplDeprecations.itemSkinFullTag.warn(attribute.context);
                    return new ElementTag(skin).getObjectAttribute(attribute.fulfill(1));
                }
                return new ElementTag(CoreUtilities.split(skin, '|').get(0)).getObjectAttribute(attribute);
            }
            attribute.echoError("This skull item does not have a skin set!");
        }
        if (attribute.startsWith("has_skin")) {
            return new ElementTag(this.getPropertyString() != null).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        PlayerProfile playerProfile = NMSHandler.itemHelper.getSkullSkin(this.item.getItemStack());
        if (playerProfile != null) {
            String name = playerProfile.getName();
            UUID uuid = playerProfile.getUniqueId();
            return String.valueOf(uuid != null ? uuid : name) + (String)(playerProfile.hasTexture() ? "|" + playerProfile.getTexture() + (String)(uuid != null && name != null ? "|" + name : "") : "");
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "skull_skin";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("skull_skin")) {
            PlayerProfile profile;
            ListTag list = mechanism.valueAsType(ListTag.class);
            String idString = list.get(0);
            String texture = null;
            if (list.size() == 1 && idString.length() > 64) {
                texture = idString;
                idString = null;
            }
            if (list.size() > 1) {
                texture = list.get(1);
            }
            if (idString == null) {
                profile = new PlayerProfile("null", new UUID(0L, 0L), texture);
            } else if (idString.length() < 3 && list.size() == 2) {
                profile = new PlayerProfile(idString, new UUID(0L, 0L), texture);
            } else if (CoreUtilities.contains(idString, '-')) {
                UUID uuid = UUID.fromString(idString);
                String name = null;
                if (list.size() > 2) {
                    name = list.get(2);
                }
                profile = new PlayerProfile(name, uuid, texture);
            } else {
                profile = new PlayerProfile(idString, Settings.nullifySkullSkinIds ? new UUID(0L, 0L) : null, texture);
            }
            if (texture == null || profile.getUniqueId() == null) {
                profile = NMSHandler.instance.fillPlayerProfile(profile);
            }
            if (texture != null) {
                profile.setTexture(texture);
            }
            if (profile.getTexture() == null) {
                return;
            }
            this.item.setItemStack(NMSHandler.itemHelper.setSkullSkin(this.item.getItemStack(), profile));
        }
    }
}

