/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities;

import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class PropertyMatchHelper<T extends ObjectTag> {
    public static LinkedHashMap<String, PropertyMatchHelper<?>> matchHelperCache = new LinkedHashMap();
    public static int MAX_MATCH_HELPER_CACHE = 1024;
    public Class<T> clazz;
    public T properObj;
    public BiPredicate<T, T> isBaseMatch;
    public List<PropertyComparison> comparisons = new ArrayList<PropertyComparison>();

    public static <T extends ObjectTag> PropertyMatchHelper<T> getPropertyMatchHelper(Class<T> clazz, String text, BiPredicate<T, T> isBaseMatch) {
        String mapKey;
        PropertyMatchHelper<Object> matchHelper;
        if (CoreConfiguration.debugVerbose) {
            Debug.verboseLog("[PropertyMatchHelper] getting helper for " + text);
        }
        if ((matchHelper = matchHelperCache.get(mapKey = DebugInternals.getClassNameOpti(clazz) + "," + text)) != null) {
            return matchHelper;
        }
        T actualObj = ObjectFetcher.getObjectFrom(clazz, text, CoreUtilities.noDebugContext);
        if (actualObj == null) {
            Debug.verboseLog("[PropertyMatchHelper] rejecting because parsed object is null");
            return null;
        }
        matchHelper = new PropertyMatchHelper<T>(clazz, actualObj, isBaseMatch);
        List<String> propertiesGiven = ObjectFetcher.separateProperties(text);
        if (propertiesGiven == null) {
            return matchHelper;
        }
        PropertyParser.ClassPropertiesInfo itemInfo = PropertyParser.propertiesByClass.get(clazz);
        for (int i = 1; i < propertiesGiven.size(); ++i) {
            Property realProp;
            String property = propertiesGiven.get(i);
            int equalSign = property.indexOf(61);
            if (equalSign == -1) {
                if (CoreConfiguration.debugVerbose) {
                    Debug.verboseLog("[PropertyMatchHelper] rejecting item because " + property + " lacks an equal sign");
                }
                return null;
            }
            String label = ObjectFetcher.unescapeProperty(property.substring(0, equalSign));
            PropertyParser.PropertyGetter getter = itemInfo.propertiesByMechanism.get(label);
            if (getter == null || (realProp = getter.get(actualObj)) == null) continue;
            matchHelper.comparisons.add(new PropertyComparison(realProp.getPropertyString(), getter));
        }
        if (matchHelperCache.size() > MAX_MATCH_HELPER_CACHE) {
            String firstMost = matchHelperCache.keySet().iterator().next();
            matchHelperCache.remove(firstMost);
        }
        if (CoreConfiguration.debugVerbose) {
            Debug.verboseLog("[PropertyMatchHelper] stored final result as " + String.valueOf(matchHelper));
        }
        matchHelperCache.put(mapKey, matchHelper);
        return matchHelper;
    }

    public PropertyMatchHelper(Class<T> clazz, T properObj, BiPredicate<T, T> isBaseMatch) {
        this.clazz = clazz;
        this.properObj = properObj;
        this.isBaseMatch = isBaseMatch;
    }

    public final boolean doesMatch(T obj) {
        if (obj == null) {
            return false;
        }
        if (!this.isBaseMatch.test(this.properObj, obj)) {
            Debug.verboseLog("[PropertyMatchHelper] deny because base match failed");
            return false;
        }
        for (PropertyComparison comparison : this.comparisons) {
            Property p = comparison.getter.get(obj);
            if (p == null) {
                Debug.verboseLog("[PropertyMatchHelper] deny because property is null");
                return false;
            }
            String val = p.getPropertyString();
            if (comparison.compareValue == null) {
                if (val == null) continue;
                Debug.verboseLog("[PropertyMatchHelper] deny because nullity");
                return false;
            }
            if (val != null && CoreUtilities.equalsIgnoreCase(comparison.compareValue, val)) continue;
            Debug.verboseLog("[PropertyMatchHelper] deny because unequal");
            return false;
        }
        return true;
    }

    public String toString() {
        return "object=" + String.valueOf(this.properObj) + ", comparisons=" + this.comparisons.stream().map(c -> c.compareValue).collect(Collectors.joining(", "));
    }

    public static class PropertyComparison {
        public String compareValue;
        public PropertyParser.PropertyGetter getter;

        public PropertyComparison(String compareValue, PropertyParser.PropertyGetter getter) {
            this.compareValue = compareValue;
            this.getter = getter;
        }
    }
}

