/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemCustomModel
extends ItemProperty<ElementTag> {
    public static boolean describes(ItemTag item) {
        return !item.getBukkitMaterial().isAir();
    }

    @Override
    public ElementTag getPropertyValue() {
        if (this.getItemMeta().hasCustomModelData()) {
            return new ElementTag(this.getItemMeta().getCustomModelData());
        }
        return null;
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        ItemMeta meta = this.getItemMeta();
        if (mechanism.hasValue() && mechanism.requireInteger()) {
            meta.setCustomModelData(Integer.valueOf(value.asInt()));
        } else {
            meta.setCustomModelData(null);
        }
        this.setItemMeta(meta);
    }

    @Override
    public String getPropertyId() {
        return "custom_model_data";
    }

    public static void register() {
        ItemCustomModel.autoRegisterNullable("custom_model_data", ItemCustomModel.class, ElementTag.class, false, new String[0]);
        PropertyParser.registerTag(ItemCustomModel.class, ElementTag.class, "has_custom_model_data", (attribute, prop) -> new ElementTag(prop.getItemMeta().hasCustomModelData()), new String[0]);
    }
}

