/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.properties.entity.EntityProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import org.bukkit.entity.Display;

public class EntityBrightness
extends EntityProperty<MapTag> {
    public static boolean describes(EntityTag entity) {
        return entity.getBukkitEntity() instanceof Display;
    }

    @Override
    public MapTag getPropertyValue() {
        Display.Brightness brightness = this.as(Display.class).getBrightness();
        if (brightness == null) {
            return null;
        }
        MapTag brightnessMap = new MapTag();
        brightnessMap.putObject("block", (ObjectTag)new ElementTag(brightness.getBlockLight()));
        brightnessMap.putObject("sky", (ObjectTag)new ElementTag(brightness.getSkyLight()));
        return brightnessMap;
    }

    @Override
    public void setPropertyValue(MapTag value, Mechanism mechanism) {
        int skyLight;
        int blockLight;
        if (value == null) {
            this.as(Display.class).setBrightness(null);
            return;
        }
        Display.Brightness brightness = this.as(Display.class).getBrightness();
        ElementTag blockLightInput = value.getElement("block");
        int n = blockLightInput != null ? (blockLightInput.isInt() ? blockLightInput.asInt() : -1) : (blockLight = brightness != null ? brightness.getBlockLight() : 0);
        if (blockLight < 0 || blockLight > 15) {
            mechanism.echoError("Invalid 'block' brightness, must be a number between 0 and 15.");
            return;
        }
        ElementTag skyLightInput = value.getElement("sky");
        int n2 = skyLightInput != null ? (skyLightInput.isInt() ? skyLightInput.asInt() : -1) : (skyLight = brightness != null ? brightness.getSkyLight() : 0);
        if (skyLight < 0 || skyLight > 15) {
            mechanism.echoError("Invalid 'sky' brightness, must be a number between 0 and 15.");
            return;
        }
        this.as(Display.class).setBrightness(new Display.Brightness(blockLight, skyLight));
    }

    @Override
    public String getPropertyId() {
        return "brightness";
    }

    public static void register() {
        EntityBrightness.autoRegisterNullable("brightness", EntityBrightness.class, MapTag.class, false, new String[0]);
    }
}

